/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.module.streaming;

import static java.lang.String.format;
import static org.apache.http.entity.ContentType.APPLICATION_JSON;
import static org.hamcrest.Matchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.http.api.HttpConstants.HttpStatus.OK;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.rule.DynamicPort;

@Feature("Repeatable Streams")
@Story("EE Routers working with Repeatable Streams")
public class EERepeatableStreamingRoutersTestCase extends MuleArtifactFunctionalTestCase {

  private static final String PAYLOAD = "{\"name\": \"tato\", \"id\": \"42\"}";
  private static final String EXPECTED_OUTPUT = "\"tato - 42\"";

  @Rule
  public DynamicPort listenPort = new DynamicPort("port");

  @Override
  protected String getConfigFile() {
    return "streaming/routers-with-streams-config.xml";
  }

  private void doTest(HttpEntity entity, String endpoint, String expected) throws Exception {
    HttpPost httpPost = new HttpPost(format("http://localhost:%s/%s", listenPort.getNumber(), endpoint));
    httpPost.setEntity(entity);

    try (CloseableHttpClient client = HttpClients.createDefault()) {
      try (CloseableHttpResponse response = client.execute(httpPost)) {
        assertThat(response.getStatusLine().getStatusCode(), is(OK.getStatusCode()));
        assertThat(IOUtils.toString(response.getEntity().getContent()), is(expected));
      }
    }
  }

  @Description("Repeatable Streaming works with Cache Scope - String Payload")
  @Test
  public void cache() throws Exception {
    HttpEntity entity = new StringEntity(PAYLOAD, APPLICATION_JSON);
    doTest(entity, "cache", EXPECTED_OUTPUT);
    // test second time
    doTest(entity, "cache", EXPECTED_OUTPUT);
  }

  @Description("Repeatable Streaming works with Cache Scope - Byte[] Payload")
  @Test
  public void cacheByteArray() throws Exception {
    HttpEntity entity = new ByteArrayEntity(PAYLOAD.getBytes(), APPLICATION_JSON);
    doTest(entity, "cache", EXPECTED_OUTPUT);
    // test second time
    doTest(entity, "cache", EXPECTED_OUTPUT);
  }

}
