/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.module.transformers;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.is;
import static org.mule.runtime.core.api.util.IOUtils.getResourceAsUrl;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.SystemProperty;

import org.junit.Rule;
import org.junit.Test;

public class XmlTransformerTestCase extends MuleArtifactFunctionalTestCase {

  @Rule
  public SystemProperty path =
      new SystemProperty("path", getResourceAsUrl("transformers/", XmlTransformerTestCase.class).getPath());

  @Override
  public String getConfigFile() {
    return "transformers/xml-to-json-transformer.xml";
  }

  @Test
  public void transformDomDocumentToXml() throws Exception {
    CoreEvent response = flowRunner("xml-flow").run();
    assertThat(response.getError().isPresent(), is(false));
  }
}
