/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.module.xa.jms;

import io.qameta.allure.Step;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.junit4.rule.SystemPropertyLambda;

import static com.mulesoft.mule.runtime.bti.api.util.BitronixConfigurationUtil.BITRONIX_TRANSACTION_TIMEOUT;

public class JmsXaTransactionTestCase extends JmsAbstractTestCase {

  @Rule
  public SystemProperty bitronix_timeout = new SystemProperty(BITRONIX_TRANSACTION_TIMEOUT, "3");

  @Rule
  public SystemProperty initialDestination =
      new SystemPropertyLambda("initialDestination", () -> newDestination("initialDestination"));

  @Rule
  public SystemProperty finalDestination = new SystemPropertyLambda("finalDestination", () -> newDestination("finalDestination"));

  @Override
  protected String getConfigFile() {
    return "xa/jms-xa-transaction.xml";
  }

  @Test
  public void worksWithXATransaction() throws Exception {
    String message = buildMessage("Test message");
    publishMessage(message, initialDestination.getValue());

    ((Flow) getFlowConstruct("test-publish")).start();

    try {
      assertMessageOnDestination(message, finalDestination.getValue());
      assertEmptyDestination(initialDestination.getValue());
    } finally {
      ((Flow) getFlowConstruct("test-publish")).stop();
    }
  }

  @Test
  public void timeoutDuringXATransaction() throws Exception {
    String firstMessage = buildMessage("timeout");
    publishMessage(firstMessage, initialDestination.getValue());
    ((Flow) getFlowConstruct("test-timeout")).start();

    try {
      assertEmptyDestination(finalDestination.getValue());
      String secondMessage = buildMessage("no timeout");
      publishMessage(secondMessage, initialDestination.getValue());
      assertMessageOnDestination(secondMessage, finalDestination.getValue());
      assertEmptyDestination(initialDestination.getValue());
    } finally {
      ((Flow) getFlowConstruct("test-timeout")).stop();
    }

  }

  @Step("Build actionable message")
  private String buildMessage(String message) {
    return "{\"message\" : \"" + message + "\"}";
  }

  @Step("Publish message")
  private void publishMessage(String message, String destination) throws Exception {
    publish(message, destination, MediaType.APPLICATION_JSON);
  }

}
