/*
 * (c) 2003-2020 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Every.everyItem;
import static org.mule.test.allure.AllureConstants.TransactionFeature.TRANSACTION;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(Parameterized.class)
@Story(TRANSACTION)
@Feature(CACHE)
public class TransactionsWithCacheTestCase extends AbstractTransactionWithRoutersTestCase {

  public TransactionsWithCacheTestCase(String processingStrategyFactoryClassname) {
    super(processingStrategyFactoryClassname);
  }

  @Override
  protected String getTransactionConfigFile() {
    return "transaction/transaction-cache.xml";
  }

  @Test
  @Issue("EE-7653")
  public void txInCache() throws Exception {
    runsInSameTransaction("tryWithCache", TX_MESSAGE, OTHER_TX_MESSAGE, TX_MESSAGE);
  }

  @Test
  @Issue("EE-7653")
  public void txInCacheExecutedThreeTimes() throws Exception {
    runsInSameTransaction("tryWithCache3Times", TX_MESSAGE, OTHER_TX_MESSAGE, TX_MESSAGE, TX_MESSAGE, TX_MESSAGE, TX_MESSAGE,
                          TX_MESSAGE);
  }

  @Test
  @Issue("EE-7653")
  public void txInAsyncCache() throws Exception {
    runsInSameTransaction("tryWithAsyncCache", TX_MESSAGE, OTHER_TX_MESSAGE, OTHER_TX_MESSAGE);
  }

  @Test
  @Issue("EE-7653")
  public void txInCacheFromSource() throws Exception {
    runsInSameTransactionAsync("toCacheQueue", TX_MESSAGE, OTHER_TX_MESSAGE, OTHER_TX_MESSAGE);
  }

  @Test
  @Issue("EE-7653")
  public void cacheError() throws Exception {
    runsInSameTransaction("cacheWithError", TX_MESSAGE, OTHER_TX_MESSAGE);
  }

  @Test
  @Issue("EE-7653")
  public void cacheInErrorHandler() throws Exception {
    runsInSameTransaction("cacheInErrorHandler", TX_MESSAGE, OTHER_TX_MESSAGE, TX_MESSAGE);
  }

  @Test
  @Issue("EE-8216")
  public void cacheInParallelForeach() throws Exception {
    flowRunner("parallelForeachCache").run();

    // Each transaction runs in its own thread
    assertThat(threads.stream().distinct().count(), is(2L));
    assertThat(runsInTx, everyItem(is(true)));
  }

}
