/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.component.tracing;

import static org.mule.test.allure.AllureConstants.Profiling.PROFILING;
import static org.mule.test.allure.AllureConstants.Profiling.ProfilingServiceStory.DEFAULT_CORE_EVENT_TRACER;
import static org.mule.test.infrastructure.profiling.tracing.TracingTestUtils.ARTIFACT_ID_KEY;
import static org.mule.test.infrastructure.profiling.tracing.TracingTestUtils.createAttributeMap;
import static org.mule.test.infrastructure.profiling.tracing.TracingTestUtils.getDefaultAttributesToAssertExistence;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasSize;
import static org.junit.Assert.assertThat;

import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.infrastructure.profiling.tracing.SpanTestHierarchy;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import javax.inject.Inject;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;

@Feature(PROFILING)
@Story(DEFAULT_CORE_EVENT_TRACER)
public class BatchAttributeTracingTestCase extends MuleArtifactFunctionalTestCase {

  public static final String EXPECTED_BATCH_JOB_SPAN_NAME = "batch:job";
  public static final String EXPECTED_BATCH_STEP_SPAN_NAME = "batch-step";
  public static final String EXPECTED_BATCH_STEP_RECORD_SPAN_NAME = "batch-step-record";
  public static final String EXPECTED_BATCH_AGGREGATOR_SPAN_NAME = "batch-aggregator";
  public static final String EXPECTED_BATCH_ON_COMPLETE_SPAN_NAME = "batch-on-complete";
  public static final String BATCH_TELEMETRY_FLOW = "batch-telemetryFlow";
  public static final String EXPECTED_FLOW_SPAN_NAME = "mule:flow";
  public static final String EXPECTED_SET_PAYLOAD_SPAN_NAME = "mule:set-payload";
  public static final String EXPECTED_LOGGER_SPAN_NAME = "mule:logger";
  public static final String EXPECTED_SET_VARIABLE_SPAN_NAME = "mule:set-variable";

  public static final int NUMBER_OF_SPANS = 24;
  private static final String TEST_ARTIFACT_ID = "BatchAttributeTracingTestCase#testFlow";

  public static final String CORRELATION_ID_KEY = "correlation.id";
  public static final String THREAD_START_ID_KEY = "thread.start.id";

  @Inject
  PrivilegedProfilingService profilingService;

  @Override
  protected String getConfigFile() {
    return "tracing/batch-success-multiple-steps-streaming-aggregators.xml";
  }

  @Test
  public void testFlow() throws Exception {
    ExportedSpanSniffer spanCapturer = profilingService.getSpanExportManager().getExportedSpanSniffer();

    try {
      flowRunner(BATCH_TELEMETRY_FLOW).withPayload(TEST_PAYLOAD).run();

      waitForAllSpansToArrive(spanCapturer);
      Collection<CapturedExportedSpan> exportedSpans = spanCapturer.getExportedSpans();

      assertThat(exportedSpans, hasSize(NUMBER_OF_SPANS));

      List<String> attributesToAssertExistence = getDefaultAttributesToAssertExistence();

      SpanTestHierarchy expectedSpanHierarchy = new SpanTestHierarchy(exportedSpans);
      expectedSpanHierarchy.withRoot(EXPECTED_FLOW_SPAN_NAME)
          .beginChildren()
          .child(EXPECTED_SET_PAYLOAD_SPAN_NAME)
          .child(EXPECTED_BATCH_JOB_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_BATCH_STEP_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_BATCH_STEP_RECORD_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_LOGGER_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .child(EXPECTED_BATCH_STEP_RECORD_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_LOGGER_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .child(EXPECTED_BATCH_STEP_RECORD_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_LOGGER_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .child(EXPECTED_BATCH_AGGREGATOR_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0/aggregator",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_SET_PAYLOAD_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/0/aggregator/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .endChildren()
          .child(EXPECTED_BATCH_STEP_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_BATCH_STEP_RECORD_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_LOGGER_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .child(EXPECTED_BATCH_STEP_RECORD_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_LOGGER_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .child(EXPECTED_BATCH_STEP_RECORD_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_LOGGER_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .child(EXPECTED_BATCH_AGGREGATOR_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1/aggregator",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_SET_PAYLOAD_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/0/route/1/aggregator/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .endChildren()
          .child(EXPECTED_BATCH_ON_COMPLETE_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/1", TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .beginChildren()
          .child(EXPECTED_SET_VARIABLE_SPAN_NAME)
          .addAttributesToAssertValue(createAttributeMap("batch-telemetryFlow/processors/1/route/1/processors/0",
                                                         TEST_ARTIFACT_ID))
          .addAttributesToAssertExistence(attributesToAssertExistence)
          .endChildren()
          .endChildren()
          .child(EXPECTED_LOGGER_SPAN_NAME)
          .endChildren();

      expectedSpanHierarchy.assertSpanTree();
      exportedSpans.forEach(span -> assertThat(span.getServiceName(), equalTo(span.getAttributes().get(ARTIFACT_ID_KEY))));
    } finally {
      spanCapturer.dispose();
    }
  }

  private void waitForAllSpansToArrive(ExportedSpanSniffer spanCapturer) {
    new PollingProber(10000, 100).check(new Probe() {

      @Override
      public boolean isSatisfied() {
        return spanCapturer.getExportedSpans().size() == NUMBER_OF_SPANS;
      }

      @Override
      public String describeFailure() {
        return "not all expected spans arrived, expected: " + NUMBER_OF_SPANS + " but got: "
            + spanCapturer.getExportedSpans().size();
      }
    });
  }
}
