/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.config.spring;

import static com.mulesoft.test.allure.AllureConstants.KryoSerializerFeature.KRYO;
import static java.util.Arrays.asList;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.sameInstance;
import static org.junit.Assert.assertThat;

import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.test.runner.RunnerDelegateTo;

import java.util.Collection;

import javax.inject.Inject;
import javax.inject.Named;

import org.junit.Test;
import org.junit.runners.Parameterized;
import org.junit.runners.Parameterized.Parameters;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;

@Feature(KRYO)
@RunnerDelegateTo(Parameterized.class)
public class InjectKryoObjectSerializerTestCase extends MuleArtifactFunctionalTestCase {

  @Parameters(name = "{0}")
  public static Collection<String> data() {
    return asList("none", "deflate", "gzip");
  }

  private final String configFile;

  public InjectKryoObjectSerializerTestCase(String compressionMode) {
    this.configFile = "serializer/kryo-serializer-" + compressionMode + "-config.xml";
  }

  @Override
  protected String getConfigFile() {
    return configFile;
  }

  @Test
  @Issue("EE-7442")
  public void injectObjectSerializer() throws Exception {
    TestObjectSerializerInjectionTarget injectionTarget =
        muleContext.getInjector().inject(new TestObjectSerializerInjectionTarget());
    assertThat(muleContext.getObjectSerializer(), is(sameInstance(injectionTarget.getObjectSerializer())));
  }

  public static class TestObjectSerializerInjectionTarget {

    @Inject
    @Named("mySerializer")
    private ObjectSerializer objectSerializer;

    public ObjectSerializer getObjectSerializer() {
      return objectSerializer;
    }
  }

}
