/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.dsl.syntax;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;

import java.util.Optional;

import org.junit.Before;
import org.junit.Test;

import com.mulesoft.mule.runtime.module.batch.api.extension.BatchExtensionModelProvider;
import com.mulesoft.mule.runtime.tracking.api.extension.TrackingEeExtensionModelProvider;

public class EeModelsDslSyntaxResolverTestCase {

  private static final String BATCH_JOB_OPERATION_NAME = "job";
  private static final String BATCH_AGGREGATOR_OPERATION_NAME = "aggregator";
  private static final String BATCH_PREFIX = "batch";
  private static final String BATCH_NAMESPACE = "http://www.mulesoft.org/schema/mule/ee/batch";

  private static final String TRACKING_CUSTOM_EVENT = "custom-event";
  private static final String TRACKING_PREFIX = "tracking";
  private static final String TRACKING_NAMESPACE = "tracking";

  private DslSyntaxResolver dslSyntaxResolver;
  private ExtensionModel batchExtensionModel = BatchExtensionModelProvider.getExtensionModel();
  private OperationModel jobOperation = batchExtensionModel.getOperationModel(BATCH_JOB_OPERATION_NAME).get();
  private OperationModel aggregatorOperation = batchExtensionModel.getOperationModel(BATCH_AGGREGATOR_OPERATION_NAME).get();
  private ExtensionModel trackingExtensionModel = TrackingEeExtensionModelProvider.getExtensionModel();

  @Before
  public void createDslSyntaxResolver() {
    dslSyntaxResolver = DslSyntaxResolver.getDefault(batchExtensionModel, new SingleExtensionImportTypesStrategy());
  }

  @Test
  public void batchJobDslSyntax() {
    DslElementSyntax syntax = dslSyntaxResolver.resolve(jobOperation);
    assertThat(syntax.getPrefix(), is(BATCH_PREFIX));
    assertThat(syntax.getElementName(), is(BATCH_JOB_OPERATION_NAME));
    assertThat(syntax.getNamespace(), is(BATCH_NAMESPACE));

    assertParameterAttribute(syntax, "jobName");
    assertParameterAttribute(syntax, "jobInstanceId");
    assertParameterAttribute(syntax, "schedulingStrategy");
    assertParameterAttribute(syntax, "targetValue");
    assertParameterAttribute(syntax, "blockSize");
    assertParameterAttribute(syntax, "jobName");
    assertParameterAttribute(syntax, "target");
    assertParameterAttribute(syntax, "maxConcurrency");

    Optional<DslElementSyntax> processRecordsSyntax = syntax.getChild("processRecords");
    assertThat(processRecordsSyntax.isPresent(), is(true));

    Optional<DslElementSyntax> onCompleteSyntax = syntax.getChild("onComplete");
    assertThat(onCompleteSyntax.isPresent(), is(true));

    Optional<DslElementSyntax> historySyntax = syntax.getChild("history");
    assertThat(historySyntax.isPresent(), is(true));

    assertThat(onCompleteSyntax.get().getChild("processors").isPresent(), is(false));
  }

  @Test
  public void batchProcessRecordsComponentDslSyntax() {
    DslElementSyntax syntax = dslSyntaxResolver.resolve(jobOperation);

    Optional<DslElementSyntax> optionalProcessRecordsSyntax = syntax.getChild("processRecords");
    assertThat(optionalProcessRecordsSyntax.isPresent(), is(true));
    DslElementSyntax processRecordsSyntax = optionalProcessRecordsSyntax.get();
    assertThat(processRecordsSyntax.getElementName(), is("process-records"));

    Optional<DslElementSyntax> optionalStepSyntax = processRecordsSyntax.getChild("step");
    assertThat(optionalStepSyntax.isPresent(), is(true));
    DslElementSyntax stepSyntax = optionalStepSyntax.get();

    assertParameterAttribute(stepSyntax, "name");
    assertParameterAttribute(stepSyntax, "acceptPolicy");
    assertParameterAttribute(stepSyntax, "acceptExpression");

    assertThat(stepSyntax.getChild("processors").isPresent(), is(false));
  }

  @Test
  public void batchAggregatorComponentDslSyntax() {
    DslElementSyntax aggregatorSyntax = dslSyntaxResolver.resolve(aggregatorOperation);

    assertParameterAttribute(aggregatorSyntax, "size");
    assertParameterAttribute(aggregatorSyntax, "streaming");
    assertParameterAttribute(aggregatorSyntax, "preserveMimeTypes");

    Optional<DslElementSyntax> processorsRecordsSyntax = aggregatorSyntax.getChild("processors");
    assertThat(processorsRecordsSyntax.isPresent(), is(false));
  }

  private void assertParameterAttribute(DslElementSyntax dslElementSyntax, String parameterName) {
    Optional<DslElementSyntax> parameterDslElementSyntax = dslElementSyntax.getAttribute(parameterName);
    assertThat(parameterDslElementSyntax.isPresent(), is(true));
    assertThat(parameterDslElementSyntax.get().getElementName(), is(""));
    assertThat(parameterDslElementSyntax.get().getAttributeName(), is(parameterName));
  }

}
