/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.el;

import static org.mule.test.allure.AllureConstants.ExpressionLanguageFeature.EXPRESSION_LANGUAGE;
import static org.mule.test.allure.AllureConstants.MuleDsl.DslValidationStory.DSL_VALIDATION_STORY;

import static com.mulesoft.mule.runtime.core.api.extension.MuleEeExtensionModelProvider.getExtensionModel;

import static org.hamcrest.Matchers.containsString;

import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;

import java.util.ArrayList;
import java.util.List;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;

@Feature(EXPRESSION_LANGUAGE)
@Story(DSL_VALIDATION_STORY)
public class ExpressionLanguageConfigurationFailuresTestCase extends AbstractConfigurationFailuresTestCase {


  @Rule
  public ExpectedException expectedException = ExpectedException.none();

  @Test
  public void eeTransformSetPayloadDwlIllegalSyntax() throws Exception {
    expectedException.expect(ConfigurationException.class);
    expectedException.expectMessage(containsString("Missing Expression"));
    loadConfiguration("el/ee-transform-set-payload-dwl-illegal-syntax-dw-config.xml");
  }

  @Test
  public void eeTransformSetAttributesDwlIllegalSyntax() throws Exception {
    expectedException.expect(ConfigurationException.class);
    expectedException.expectMessage(containsString("Missing Expression"));
    loadConfiguration("el/ee-transform-set-attributes-dwl-illegal-syntax-dw-config.xml");
  }

  @Test
  public void eeTransformSetVariablesDwlIllegalSyntax() throws Exception {
    expectedException.expect(ConfigurationException.class);
    expectedException.expectMessage(containsString("Missing Expression"));
    loadConfiguration("el/ee-transform-set-variables-dwl-illegal-syntax-dw-config.xml");
  }

  @Override
  protected boolean mockExpressionExecutor() {
    return false;
  }

  @Override
  protected void applyConfiguration(DefaultMuleConfiguration muleConfiguration) {
    super.applyConfiguration(muleConfiguration);

    muleConfiguration.setMinMuleVersion(new MuleVersion("4.5.0"));
  }

  @Override
  protected List<ExtensionModel> getRequiredExtensions() {
    final List<ExtensionModel> extensions = new ArrayList<>();
    extensions.addAll(super.getRequiredExtensions());
    extensions.add(getExtensionModel());

    return extensions;
  }
}
