/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.module.cache;

import static com.mulesoft.test.allure.AllureConstants.CacheFeature.CACHE;

import static org.junit.Assert.assertEquals;

import org.mule.extension.objectstore.api.ExtensionObjectStore;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;

import java.lang.reflect.Field;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import org.junit.Test;

@Feature(CACHE)
public class ObjectStoreCachingStrategyTest extends MuleArtifactFunctionalTestCase {

  private static final String CONFIG_FILE_NAME = "module/cache/flow-using-object-store-caching-strategy.xml";

  @Override
  protected String getConfigFile() {
    return CONFIG_FILE_NAME;
  }

  public void setUp() throws Exception {}

  public void tearDown() throws Exception {}

  void checkStartedField(ExtensionObjectStore objectStore, boolean expectedValue)
      throws IllegalAccessException, NoSuchFieldException {
    Field startedField = ExtensionObjectStore.class.getDeclaredField("started");
    startedField.setAccessible(true);
    Boolean started = (Boolean) startedField.get(objectStore);
    assertEquals(started, expectedValue);
  }

  @Description("Restarts a caching strategy that uses an external object store")
  @Issue("W-11203794")
  @Test
  public void startingOrStoppingTheCachingStrategyShouldNotAffectNotOwnedObjectStore() throws Exception {
    ExtensionObjectStore objectStore = (ExtensionObjectStore) registry.lookupByName("Object_store").get();

    checkStartedField(objectStore, true);
    stopCachingStrategy();
    checkStartedField(objectStore, true);

    objectStore.stop();

    checkStartedField(objectStore, false);
    startCachingStrategy();
    checkStartedField(objectStore, false);

  }

  private void stopCachingStrategy() throws MuleException {
    registry.<Stoppable>lookupByName("Caching_Strategy").get().stop();
  }

  private void startCachingStrategy() throws MuleException {
    registry.<Startable>lookupByName("Caching_Strategy").get().start();
  }
}
