/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.module.http;


import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.CoreMatchers.notNullValue;
import static org.hamcrest.text.IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.http.api.HttpConstants.Method.POST;

import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;

import org.junit.Rule;
import org.junit.Test;

import java.io.InputStream;


public class TransformSingleQuotedXmlToJsonWhileStreamingTestCase extends MuleArtifactFunctionalTestCase {

  private static final String TEST_JSON_FILE = "streaming/orders.json";
  private static final String TEST_XML_FILE = "streaming/orders.xml";
  private static final int RESPONSE_TIMEOUT = 20000;

  @Rule
  public DynamicPort httpPort = new DynamicPort("httpPort");

  @Rule
  public TestHttpClient httpClient = new TestHttpClient.Builder(getService(HttpService.class)).build();

  @Override
  protected String getConfigFile() {
    return "streaming/xml-to-json-transform.xml";
  }

  @Test
  public void inMemoryStreaming() throws Exception {
    transformAndAssert("inMemoryTransform");
  }

  @Test
  public void fileStreaming() throws Exception {
    transformAndAssert("fileStoreTransform");
  }

  @Test
  public void noStreaming() throws Exception {
    transformAndAssert("nonRepeatableTransform");
  }

  private void transformAndAssert(String endpoint) throws Exception {
    String xml = getTestContent(TEST_XML_FILE);

    HttpRequest request = HttpRequest.builder()
        .uri(String.format("http://localhost:%d/%s", httpPort.getNumber(), endpoint))
        .method(POST)
        .addHeader("Content-Type", "text/xml")
        .entity(new ByteArrayHttpEntity(xml.getBytes()))
        .build();

    HttpResponse response = httpClient.send(request, RESPONSE_TIMEOUT, false, null);
    String json = IOUtils.toString(response.getEntity().getContent());
    assertThat(json, equalToIgnoringWhiteSpace(getTestContent(TEST_JSON_FILE)));
  }

  private String getTestContent(String path) throws Exception {
    try (InputStream in =
        TransformSingleQuotedXmlToJsonWhileStreamingTestCase.class.getClassLoader().getResourceAsStream(path)) {
      assertThat("test file not found: " + path, in, is(notNullValue()));
      return IOUtils.toString(in);
    }
  }
}
