/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.module.streaming;

import static org.hamcrest.Matchers.equalTo;
import static org.junit.Assert.assertThat;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.api.streaming.StreamingManager;

import javax.inject.Inject;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.junit.Test;


@Feature("Streaming")
@Story("Object Streaming")
public class EEStreamingManagerConfiguratorTestCase extends MuleArtifactFunctionalTestCase {

  @Inject
  private StreamingManager streamingManager;

  @Override
  protected String[] getConfigFiles() {
    return new String[] {};
  }

  @Test
  @Description("When Running in EE, a custom StreamingManager is used")
  public void eeStreamingManagerConfigured() throws Exception {
    // Checks that the streaming manager is the one from EE. It uses the class name as the class is not exported on the module
    assertThat(streamingManager.getClass().getName(),
               equalTo("com.mulesoft.mule.runtime.core.internal.streaming.EEStreamingManager"));
  }

  @Test
  @Description("When Running in EE, the default byte streaming strategy uses a file store")
  public void defaultByteStreamingStrategyIsFileStore() throws Exception {
    // Checks that the streaming manager is the one from EE. It uses the class name as the class is not exported on the module
    assertThat(streamingManager.forBytes().getDefaultCursorProviderFactory().getClass().getName(),
               equalTo("com.mulesoft.mule.runtime.core.internal.streaming.bytes.factory.FileStoreCursorStreamProviderFactory"));
  }

  @Test
  @Description("When Running in EE, the default object streaming strategy uses a file store")
  public void defaultObjectStreamingStrategyIsFileStore() throws Exception {
    assertThat(streamingManager.forObjects().getDefaultCursorProviderFactory().getClass().getName(),
               equalTo("com.mulesoft.mule.runtime.core.internal.streaming.object.factory.FileStoreCursorIteratorProviderFactory"));
  }
}
