/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.notification;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.Before;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.MessageProcessorNotificationListener;
import org.mule.tck.util.FlowTraceUtils;

import java.util.concurrent.CountDownLatch;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.junit.Assert.assertThat;
import static org.mule.tck.util.FlowTraceUtils.FlowStackAsserter.stackToAssert;
import static org.mule.tck.util.FlowTraceUtils.assertStackElements;
import static org.mule.tck.util.FlowTraceUtils.isFlowStackElement;
import static org.mule.test.allure.AllureConstants.Logging.LOGGING;
import static org.mule.test.allure.AllureConstants.Logging.LoggingStory.FLOW_STACK;

@Feature(LOGGING)
@Story(FLOW_STACK)
public class FlowStackTestCase extends MuleArtifactFunctionalTestCase {

  @Override
  protected String getConfigFile() {
    return "notification/flow-stack.xml";
  }

  @Before
  public void before() {
    muleContext.getNotificationManager().addInterfaceToType(MessageProcessorNotificationListener.class,
                                                            MessageProcessorNotification.class);

    stackToAssert = null;
    FlowTraceUtils.FlowStackAsyncAsserter.latch = new CountDownLatch(1);
  }

  @Test
  @Issue("MULE-18458")
  public void flowStackWithErrorHandlerDW() throws Exception {
    flowRunner("flowStackinErrorHandlerAndDW").run();
    assertThat(stackToAssert, not(nullValue()));
    assertStackElements(stackToAssert,
                        isFlowStackElement("flow", "flow/processors/0"),
                        isFlowStackElement("flowStackinErrorHandlerAndDW",
                                           "flowStackinErrorHandlerAndDW/errorHandler/0/processors/1"));
  }

}
