/*
 * (c) 2003-2023 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.variables;

import static org.hamcrest.CoreMatchers.nullValue;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.CoreMatchers.is;
import static org.mule.runtime.api.util.MuleSystemProperties.SET_VARIABLE_WITH_NULL_VALUE_PROPERTY;
import static org.mule.test.allure.AllureConstants.VariablesValues.NullValue.NULL_VALUE;
import static org.mule.test.allure.AllureConstants.VariablesValues.VARIABLES_VALUES;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(VARIABLES_VALUES)
@Story(NULL_VALUE)
@RunnerDelegateTo(Parameterized.class)
public class VariableNullValueTestCase extends MuleArtifactFunctionalTestCase {

  @Override
  protected String getConfigFile() {
    return "variables/null-value.xml";
  }

  private Boolean featureEnabled;
  private String minMuleVersion;

  @Rule
  public SystemProperty systemProperty;

  @Parameterized.Parameters(name = "MuleVersion={1} and system property {2}")
  public static Object[][] params() {
    return new Object[][] {
        {true, "4.3.0", "true"}, {false, "4.4.0", "false"}, {true, "4.4.0", null}, {false, "4.3.0", null}
    };
  }

  public VariableNullValueTestCase(boolean featureEnabled, String minMuleVersion, String sysProp) {
    this.featureEnabled = featureEnabled;
    this.minMuleVersion = minMuleVersion;
    if (sysProp != null) {
      this.systemProperty = new SystemProperty(SET_VARIABLE_WITH_NULL_VALUE_PROPERTY, sysProp);
    }
  }

  @Test
  @Issue("MULE-19443")
  public void withSetVariable() throws Exception {
    CoreEvent event = flowRunner("withSetVariable").run();
    if (featureEnabled) {
      assertThat(event.getVariables().containsKey("test"), is(true));
      assertThat(event.getVariables().get("test").getValue(), is(nullValue()));
    } else {
      assertThat(event.getVariables().containsKey("test"), is(false));
    }
  }

  @Test
  @Issue("MULE-19443")
  public void withDW() throws Exception {
    CoreEvent event = flowRunner("withDW").keepStreamsOpen().run();
    assertThat(event.getVariables().containsKey("test"), is(true));
    assertThat(event.getVariables().get("test").getValue(), is(nullValue()));
  }

  @Test
  @Issue("MULE-19443")
  public void withTarget() throws Exception {
    CoreEvent event = flowRunner("withTargetValue").keepStreamsOpen().run();
    assertThat(event.getVariables().containsKey("test"), is(true));
    assertThat(event.getVariables().get("test").getValue(), is(nullValue()));
  }

  @Override
  protected DefaultMuleConfiguration createMuleConfiguration() {
    DefaultMuleConfiguration muleConfiguration = super.createMuleConfiguration();
    if (minMuleVersion != null) {
      muleConfiguration.setMinMuleVersion(new MuleVersion(minMuleVersion));
    }
    return muleConfiguration;
  }
}
