/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction.xa;

import static java.util.Collections.emptyList;
import static java.util.Collections.singletonList;

import org.mule.extension.db.integration.model.DerbyTestDatabase;

import java.sql.SQLException;
import java.util.List;

import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;

public abstract class AbstractMultipleConfigsXaTransactionalTestCase extends AbstractXaTransactionalTestCase {

  private static final String DB_CONFIG_1 = "dbConfig1";
  private static final String DB_CONFIG_2 = "dbConfig2";

  @Parameterized.Parameters(name = "{2}")
  public static List<Object[]> parameters() {
    DerbyTestDatabase derbyTestDatabase = new DerbyTestDatabase();
    return singletonList(new Object[] {"derby-multi-config-xa-db-config.xml", derbyTestDatabase, derbyTestDatabase.getDbType(),
        emptyList()});
  }

  @Override
  protected String[] getFlowConfigurationResources() {
    return new String[] {getTransactionManagerResource(), "xa-multi-config-transactional-config.xml"};
  }

  @Before
  @Override
  public void configDB() throws SQLException {
    testDatabase.createDefaultDatabaseConfig(getDataSource(DB_CONFIG_1));
    testDatabase.createDefaultDatabaseConfig(getDataSource(DB_CONFIG_2));
  }

  @Test
  public void commitTxUpdateOutsideABlock() throws Exception {
    executeTransaction("commitTxUpdateOutsideABlock");
    validateDbState(MERCURY, DB_CONFIG_1);
    validateDbState(MERCURY, DB_CONFIG_2);
  }

  @Test
  public void commitAnOptionalTxUpdateIsANonTxBlock() throws Exception {
    executeTransaction("commitAnOptionalTxUpdateIsANonTxBlock");
    validateDbState(MERCURY, DB_CONFIG_1);
    validateDbState(MERCURY, DB_CONFIG_2);
  }

  @Test
  public void commitNonTxUpdateInATxBlock() throws Exception {
    executeTransaction("commitNonTxUpdateInATxBlock");
    validateDbState(MERCURY, DB_CONFIG_1);
    validateDbState(MERCURY, DB_CONFIG_2);
  }

  @Test
  public void rollbackTxUpdateInATxBlock() throws Exception {
    executeTransaction("rollbackTxUpdateInATxBlock");
    validateDbState(MARS, DB_CONFIG_1);
    validateDbState(MARS, DB_CONFIG_2);
  }

  @Test
  public void rollbackOptionalTxUpdateInATxBlock() throws Exception {
    executeTransaction("rollbackOptionalTxUpdateInATxBlock");
    validateDbState(MARS, DB_CONFIG_1);
    validateDbState(MARS, DB_CONFIG_2);
  }
}
