/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction.xa;

import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.Matchers.instanceOf;
import static org.mule.functional.api.exception.ExpectedError.none;

import org.mule.extension.db.integration.AbstractDbIntegrationTestCase;
import org.mule.extension.db.integration.TestDbConfig;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.runtime.api.connection.ConnectionException;

import java.util.List;

import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class XaDatasourcePoolingLimitTestCase extends AbstractDbIntegrationTestCase implements XaTestCaseRunnerConfig {

  @Rule
  public ExpectedError expected = none();

  @Parameterized.Parameters(name = "{2}")
  public static List<Object[]> parameters() {
    return TestDbConfig.getDerbyResource();
  }

  @Override
  protected String[] getFlowConfigurationResources() {
    return new String[] {"bti-config.xml",
        "integration/config/derby-minimum-pooling-db-config.xml", "integration/xa/xa-connection-pooling-config.xml"};
  }

  @Test
  public void limitsConnections() throws Exception {
    expected.expectCause(instanceOf(ConnectionException.class));
    expected
        .expectMessage(containsString("unable to get a connection from pool of a PoolingDataSource containing an XAPool of resource"));

    flowRunner("defaultQueryRequestResponse").run();
  }
}
