/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction.xa;

import static org.hamcrest.CoreMatchers.instanceOf;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.extension.db.integration.AbstractDbIntegrationTestCase;
import org.mule.extension.db.integration.TestDbConfig;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.message.Message;

import java.util.List;

public class XaDatasourcePoolingTestCase extends AbstractDbIntegrationTestCase implements XaTestCaseRunnerConfig {

  @Parameterized.Parameters(name = "{2}")
  public static List<Object[]> parameters() {
    return TestDbConfig.getDerbyResource();
  }

  @Override
  protected String[] getFlowConfigurationResources() {
    return new String[] {"bti-config.xml",
        "integration/config/derby-xa-pooling-db-config.xml", "integration/xa/xa-connection-pooling-config.xml"};
  }

  @Test
  public void providesMultipleConnections() throws Exception {
    FlowRunner flowRunner = flowRunner("defaultQueryRequestResponse");
    Message response = flowRunner.withPayload(TEST_MESSAGE).run().getMessage();

    assertThat(response.getPayload().getValue(), is(instanceOf(List.class)));
    List<Message> messageCollection = (List<Message>) response.getPayload().getValue();
    assertThat(messageCollection, hasSize(2));
  }
}
