/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction.xa;

import org.mule.extension.db.internal.domain.connection.DbConnectionProvider;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;

/**
 * Interface with the only purpose of sharing the {@link ArtifactClassLoaderRunnerConfig} between test cases
 */
@ArtifactClassLoaderRunnerConfig(exportPluginClasses = {DbConnectionProvider.class},
    applicationSharedRuntimeLibs = {"org.apache.derby:derby", "org.apache.activemq:activemq-client",
        "org.apache.activemq:activemq-broker", "org.fusesource.hawtbuf:hawtbuf"},
    applicationRuntimeLibs = {"org.mule.connectors:mule-db-connector:tests"})
public interface XaTestCaseRunnerConfig {
}
