/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction.xa;

import static org.hamcrest.CoreMatchers.containsString;
import static org.hamcrest.core.IsInstanceOf.instanceOf;
import static org.junit.internal.matchers.ThrowableMessageMatcher.hasMessage;
import static org.mule.functional.junit4.matchers.ThrowableRootCauseMatcher.hasRootCause;

import io.qameta.allure.Issue;
import org.mule.functional.junit4.DomainFunctionalTestCase;
import org.mule.runtime.api.lifecycle.InitialisationException;

import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;

@Ignore("MULE-12310: domain must run using the isolated test runner, otherwise the test fails when executed in a suite")
@Issue("MULE-12310")
public class XaTransactionManagerTestCase extends DomainFunctionalTestCase {

  @Rule
  public ExpectedException thrown = ExpectedException.none();

  @Override
  public void setUpMuleContexts() throws Exception {
    thrown.expect(InitialisationException.class);
    thrown
        .expect(hasMessage(containsString("No qualifying bean of type [org.mule.runtime.core.api.transaction.TransactionManagerFactory] is defined: expected single matching bean but found 2:")));
    thrown.expect(hasRootCause(instanceOf(NoUniqueBeanDefinitionException.class)));
    super.setUpMuleContexts();
  }

  public static final String APPLICATION_NAME = "app";

  @Override
  protected String getDomainConfig() {
    return "bti-config.xml";
  }

  @Override
  public ApplicationConfig[] getConfigResources() {
    return new ApplicationConfig[] {
        new ApplicationConfig(APPLICATION_NAME, new String[] {"app-with-tx-manager-config.xml"})};
  }

  @Test
  public void validateOnlyOneTxManagerCanBeUsed() {
    // This is never called since the exception is thrown during init.
    getMuleContextForApp(APPLICATION_NAME).getTransactionManager();
  }
}
