/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction.xa;

import static org.hamcrest.CoreMatchers.not;
import static org.hamcrest.CoreMatchers.nullValue;
import static org.junit.Assert.assertThat;
import org.mule.extension.db.integration.AbstractDbIntegrationTestCase;
import org.mule.functional.api.component.TestConnectorQueueHandler;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

import org.junit.Test;

public class XaTransactionsPersistentQueueTestCase extends AbstractDbIntegrationTestCase implements XaTestCaseRunnerConfig {

  private static final String TEST_MESSAGE = "TEST_MESSAGE";

  @Override
  protected String[] getFlowConfigurationResources() {
    return new String[] {"xa-transaction-persistent-queue-flow.xml"};
  }

  @Test
  public void testOutboundRouterTransactions() throws Exception {
    TestConnectorQueueHandler queueHandler = new TestConnectorQueueHandler(registry);

    flowRunner("XaTestService").withPayload(TEST_MESSAGE).run().getMessage();

    assertThat(queueHandler.read("finish", AbstractMuleContextTestCase.RECEIVE_TIMEOUT).getMessage(), not(nullValue()));
  }
}
