/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction.xa.bti;

import static org.mule.tck.probe.PollingProber.probe;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;
import org.mule.test.transactional.connection.DummyXaResource;
import com.mulesoft.mule.test.transaction.xa.XaTestCaseRunnerConfig;
import org.junit.Test;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BtiExtensionsXaTestCase extends MuleArtifactFunctionalTestCase implements XaTestCaseRunnerConfig {

  @Override
  protected String[] getConfigFiles() {
    return new String[] {"bti-config.xml", "tx-extension-xa-transactional-config.xml"};
  }

  @Test
  public void rollbackXaTransaction() throws Exception {
    flowRunner("rollbackXaTransaction").run();
  }

  @Test
  public void commitXaTransaction() throws Exception {
    flowRunner("commitXaTransaction").run();
  }

  @Test
  public void commitInSourceWithSingleTxResource() throws Exception {
    startFlow("commitInSourceWithSingleTxResource");

    validateXaResource(getXaResource(), true, false, false);
  }

  @Test
  public void commitInSourceWithMultipleTxResources() throws Exception {
    startFlow("commitInSourceWithMultipleTxResources");

    validateXaResource(getXaResource(), true, true, false);
    validateXaResource(getXaResource(), true, true, false);
  }

  @Test
  public void rollbackInSourceWithSingleTxResource() throws Exception {
    startFlow("rollbackInSourceWithSingleTxResource");

    validateXaResource(getXaResource(), false, false, true);
  }

  @Test
  public void rollbackInSourceWithMultipleTxResources() throws Exception {
    startFlow("rollbackInSourceWithMultipleTxResources");

    validateXaResource(getXaResource(), false, false, true);
    validateXaResource(getXaResource(), false, false, true);
  }

  private void validateXaResource(DummyXaResource xaResource, boolean isCommitStarted, boolean isPrepared, boolean isRollback) {
    probe(5000, 100, xaResource::isTxStarted);
    probe(5000, 100, () -> xaResource.isCommitStarted() == isCommitStarted);
    probe(5000, 100, () -> xaResource.isRollbackExecuted() == isRollback);
    probe(5000, 100, () -> xaResource.isPrepared() == isPrepared);
    probe(5000, 100, xaResource::isTxEnded);
  }

  private void startFlow(String flowName) throws Exception {
    ((Flow) getFlowConstruct(flowName)).start();
  }

  private DummyXaResource getXaResource() {
    return (DummyXaResource) XaMessageStorage.getConnection().getXAResource();
  }

  public static class XaMessageStorage implements Processor {

    private static Queue<XATransactionalConnection> messages = new ConcurrentLinkedQueue<>();

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
      messages.add((XATransactionalConnection) event.getMessage().getPayload().getValue());
      return event;
    }

    public static XATransactionalConnection getConnection() {
      probe(() -> !messages.isEmpty());
      return messages.poll();
    }
  }
}
