/*
 * (c) 2003-2019 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.mule.test.transaction.xa.jms;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.tck.probe.JUnitLambdaProbe;
import org.mule.tck.probe.PollingProber;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class JmsMessageStorage implements Processor {

  private static Queue<CoreEvent> EVENTS = new ConcurrentLinkedQueue<>();
  private static Queue<Message> MESSAGES = new ConcurrentLinkedQueue<>();

  @Override
  public CoreEvent process(CoreEvent event) throws MuleException {
    EVENTS.add(event);
    MESSAGES.add(event.getMessage());
    return event;
  }

  public static void cleanUpQueue() {
    MESSAGES = new ConcurrentLinkedQueue<>();
    EVENTS = new ConcurrentLinkedQueue<>();
  }

  public static Result<TypedValue<Object>, Object> pollMessage() {
    Message message = pollMuleMessage();
    return Result.<TypedValue<Object>, Object>builder()
        .output(message.getPayload())
        .attributes(message.getAttributes().getValue())
        .build();
  }

  public static Message pollMuleMessage() {
    return poll(MESSAGES);
  }

  public static CoreEvent pollEvent() {
    return poll(EVENTS);
  }

  private static <T> T poll(Queue<T> queue) {
    new PollingProber(10000, 100).check(new JUnitLambdaProbe(() -> !queue.isEmpty()));
    return queue.poll();
  }

  public static int receivedMessages() {
    return MESSAGES.size();
  }
}
