/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic;

import com.mulesoft.mule.transport.epic.EpicBridgesLicenseCheck;
import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.ValidationLevel;
import com.mulesoft.mule.transport.epic.protocols.HL7Protocol;
import com.mulesoft.mule.transport.epic.transformers.EpicBridgesDefaultInboundTransformer;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.module.reboot.EEMuleContainerBootstrap;
import org.mule.transport.tcp.TcpConnector;

public class EpicBridgesConnector
extends TcpConnector {
    public static final String HL7 = "hl7";
    private boolean hl7Licensed;
    private ValidationLevel validation = ValidationLevel.WEAK;
    private HL7Encoding hl7encoding = HL7Encoding.ER7;

    public EpicBridgesConnector(MuleContext context) {
        super(context);
        this.setTcpProtocol(new HL7Protocol());
    }

    public String getProtocol() {
        return HL7;
    }

    protected void doInitialise() throws InitialisationException {
        super.doInitialise();
    }

    private final void checkHL7Entitlement() throws InitialisationException {
        if (EEMuleContainerBootstrap.isEval()) {
            this.logger.info((Object)"Mule EE evaluation version. Enabling MuleSoft Enterprise Java Connector for HL7 usage.");
            this.hl7Licensed = true;
        } else {
            try {
                EpicBridgesLicenseCheck.checkHL7Entitlement();
                this.logger.info((Object)"Found MuleSoft Enterprise Java Connector for HL7 usage license entitlement.");
                this.hl7Licensed = true;
            }
            catch (Throwable e) {
                this.logger.warn((Object)"Invalid license for MuleSoft Enterprise Java Connector for HL7, please contact MuleSoft info@mulesoft.com");
                this.hl7Licensed = false;
                throw new InitialisationException(e, (Initialisable)this);
            }
        }
    }

    public HL7Encoding getHl7Encoding() {
        return this.hl7encoding;
    }

    public void setHl7Encoding(HL7Encoding hl7encoding) {
        this.hl7encoding = hl7encoding;
    }

    public List<Transformer> getDefaultInboundTransformers(ImmutableEndpoint endpoint) {
        List transformers = super.getDefaultInboundTransformers(endpoint);
        if (transformers != null) {
            for (Transformer t : transformers) {
                if (!(t instanceof EpicBridgesDefaultInboundTransformer)) continue;
                EpicBridgesDefaultInboundTransformer defaultTransformer = (EpicBridgesDefaultInboundTransformer)t;
                defaultTransformer.setHl7encoding(this.getHl7Encoding().toString());
                defaultTransformer.setEnableValidation("STRONG".equals(this.getValidation().toString()));
            }
        }
        return transformers;
    }

    public void setValidation(ValidationLevel validation) {
        this.validation = validation;
    }

    public ValidationLevel getValidation() {
        return this.validation;
    }
}

