/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import com.mulesoft.mule.transport.epic.EpicBridgesValidationException;
import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.util.ACKGenerator;
import com.mulesoft.mule.transport.epic.util.HL7FormatConverter;
import com.mulesoft.mule.transport.epic.util.VersionComparator;
import java.lang.reflect.Method;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.exception.CatchMessagingExceptionStrategy;
import org.mule.util.AttributeEvaluator;

public class EpicBridgesExceptionStrategy
extends CatchMessagingExceptionStrategy {
    private AttributeEvaluator ackCode;

    protected void doInitialise(MuleContext muleContext) throws InitialisationException {
        super.doInitialise(muleContext);
        if (this.ackCode != null) {
            this.ackCode.initialize(muleContext.getExpressionManager());
        }
    }

    protected MuleEvent beforeRouting(Exception exception, MuleEvent event) {
        MuleMessage message = event.getMessage();
        Object hl7Payload = message.getPayload();
        Exception validationException = (Exception)message.getInvocationProperty("HL7:ERR");
        HL7Encoding defaultEncoding = HL7FormatConverter.getHL7Encoding(hl7Payload);
        Message hl7Msg = null;
        try {
            hl7Msg = HL7FormatConverter.toHAPIMessage(hl7Payload, false);
        }
        catch (HL7Exception e1) {
            this.logger.warn((Object)"Unable to convert message to default encoding; reverted to original", (Throwable)e1);
        }
        Exception mainException = validationException != null ? validationException : exception;
        this.logger.debug((Object)("HLExceptionStrategy MainException is: " + mainException));
        HL7Exception hl7Exception = null;
        String ackCodeString = "";
        if (this.ackCode != null) {
            ackCodeString = this.ackCode.resolveValue(message).toString();
        } else if (mainException instanceof HL7Exception) {
            ackCodeString = "AE";
            hl7Exception = (HL7Exception)((Object)mainException);
        } else if (mainException instanceof EpicBridgesValidationException) {
            ackCodeString = "AE";
            HL7Exception[] errors = ((EpicBridgesValidationException)mainException).getValidationErrors();
            if (errors != null && errors.length > 0) {
                hl7Exception = errors[0];
            }
        } else {
            ackCodeString = "AR";
            hl7Exception = new HL7Exception("Internal error", (Throwable)exception);
        }
        try {
            Method errMethod;
            Message ack = null;
            String version = "";
            if (hl7Msg != null) {
                ack = hl7Msg.generateACK(ackCodeString, hl7Exception);
                version = hl7Msg.getVersion();
            } else {
                String ackString = ACKGenerator.generateAckResponse(hl7Payload.toString(), "AR", "Unable to parse the incoming message; cause is: " + mainException.getMessage());
                ack = HL7FormatConverter.toHAPIMessage(ackString, false);
            }
            VersionComparator comparator = new VersionComparator();
            if (mainException != null && mainException instanceof EpicBridgesValidationException && comparator.compare(version, "2.5") >= 0 && (errMethod = ack.getClass().getMethod("insertERR", Integer.TYPE)) != null) {
                this.logger.debug((Object)"Populating ERR segments...");
                HL7Exception[] errors = ((EpicBridgesValidationException)mainException).getValidationErrors();
                for (int i = 0; i < errors.length; ++i) {
                    Segment errSegment = (Segment)errMethod.invoke((Object)ack, i);
                    errors[i].populate(errSegment, null);
                }
            }
            this.logger.debug((Object)("ExceptionStrategy generated ACK Message: " + ack));
            message.setPayload(HL7FormatConverter.toDefaultEncoding(ack, defaultEncoding, false));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to generate ACK message!", (Throwable)e);
            message.setPayload(hl7Payload);
        }
        MuleEvent currentEvent = super.beforeRouting(exception, event);
        return currentEvent;
    }

    public AttributeEvaluator getAckCode() {
        return this.ackCode;
    }

    public void setAckCode(AttributeEvaluator ackCode) {
        this.ackCode = ackCode;
    }
}

