/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.check.DefaultValidator;
import ca.uhn.hl7v2.conf.parser.ProfileParser;
import ca.uhn.hl7v2.conf.spec.RuntimeProfile;
import ca.uhn.hl7v2.model.Message;
import com.mulesoft.mule.transport.epic.EpicBridgesValidationException;
import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.util.HL7FormatConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleMessage;
import org.mule.api.routing.filter.Filter;
import org.mule.message.DefaultExceptionPayload;
import org.mule.util.StringUtils;

public class EpicBridgesProfileValidatorFilter
implements Filter {
    private String profile;
    private static final Log logger = LogFactory.getLog(EpicBridgesProfileValidatorFilter.class);

    public boolean accept(MuleMessage message) {
        Object payload = message.getPayload();
        if (!(payload instanceof String) && !(payload instanceof Message)) {
            return false;
        }
        HL7Encoding defaultEncoding = HL7FormatConverter.getHL7Encoding(payload);
        Message hl7Msg = null;
        try {
            hl7Msg = HL7FormatConverter.toHAPIMessage(payload, true);
        }
        catch (HL7Exception e1) {
            logger.warn((Object)("Invalid message: " + payload), (Throwable)e1);
            return false;
        }
        if (StringUtils.isEmpty((String)this.profile)) {
            logger.warn((Object)"Conformance Profile is not set, rejecting!");
            return false;
        }
        ProfileParser profileParser = new ProfileParser(false);
        RuntimeProfile rtp = null;
        if (this.profile.startsWith("classpath:")) {
            try {
                String profileFileName = this.profile.substring(10);
                logger.debug((Object)("Loading conformance profile " + profileFileName));
                rtp = profileParser.parseClasspath(profileFileName);
            }
            catch (Exception e) {
                logger.warn((Object)("Unable to load profile from classpath: " + this.profile), (Throwable)e);
                return false;
            }
        }
        try {
            rtp = profileParser.parse(this.profile);
        }
        catch (ProfileException e) {
            logger.warn((Object)("Unable to parse profile: " + this.profile), (Throwable)e);
            return false;
        }
        DefaultValidator validator = new DefaultValidator();
        try {
            HL7Exception[] exceptions = validator.validate(hl7Msg, rtp.getMessage());
            if (exceptions != null && exceptions.length > 0) {
                EpicBridgesValidationException validationException = new EpicBridgesValidationException("Invalid message!", exceptions);
                logger.debug((Object)("Message validated, found errors: " + validationException.getValidationErrorsAsString()));
                DefaultExceptionPayload exceptionPayload = new DefaultExceptionPayload((Throwable)validationException);
                message.setExceptionPayload((ExceptionPayload)exceptionPayload);
                message.setInvocationProperty("HL7:ERR", (Object)validationException);
                return false;
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Unable to validate message!", (Throwable)e);
            return false;
        }
        return true;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }
}

