/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic;

import ca.uhn.hl7v2.HL7Exception;

public class EpicBridgesValidationException
extends Exception {
    private static final long serialVersionUID = 222708816661199825L;
    private HL7Exception[] validationErrors;

    public EpicBridgesValidationException(String message, HL7Exception[] validationErrors) {
        super(message);
        this.validationErrors = validationErrors;
    }

    public HL7Exception[] getValidationErrors() {
        return this.validationErrors;
    }

    public String getValidationErrorsAsString() {
        if (this.validationErrors == null || this.validationErrors.length == 0) {
            return "No problems found";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("Found " + this.validationErrors.length + " problems: \n");
        for (int i = 0; i < this.validationErrors.length; ++i) {
            HL7Exception exception = this.validationErrors[i];
            sb.append(" * " + ((Object)((Object)exception)).getClass().getSimpleName() + " - " + exception.getMessage() + "\n");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + this.getValidationErrorsAsString();
    }
}

