/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.processors;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import com.mulesoft.mule.transport.epic.EpicBridgesValidationException;
import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.ValidationLevel;
import com.mulesoft.mule.transport.epic.util.HL7FormatConverter;
import com.mulesoft.mule.transport.epic.util.VersionComparator;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.AttributeEvaluator;

public class EpicBridgesAckComponent
implements Initialisable,
MuleContextAware,
MessageProcessor {
    protected static final Log logger = LogFactory.getLog(EpicBridgesAckComponent.class);
    private MuleContext muleContext;
    private AttributeEvaluator ackCode;
    private AttributeEvaluator validation;

    public void initialise() throws InitialisationException {
        this.ackCode.initialize(this.muleContext.getExpressionManager());
        if (this.validation != null) {
            this.validation.initialize(this.muleContext.getExpressionManager());
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            Method errMethod;
            MuleMessage message = event.getMessage();
            Object hl7Payload = message.getPayload();
            ExceptionPayload exceptionPayload = message.getExceptionPayload();
            HL7Encoding defaultEncoding = HL7FormatConverter.getHL7Encoding(hl7Payload);
            logger.debug((Object)("ACK Component received message: " + hl7Payload));
            Message hl7Msg = HL7FormatConverter.toHAPIMessage(hl7Payload, ValidationLevel.STRONG.getValidationLevel().equals(this.validation.resolveValue(message)));
            HL7Exception hl7Exception = null;
            Throwable errorPayload = null;
            if (exceptionPayload != null) {
                HL7Exception[] errors;
                errorPayload = exceptionPayload.getException();
                if (errorPayload instanceof HL7Exception) {
                    hl7Exception = (HL7Exception)errorPayload;
                } else if (errorPayload instanceof EpicBridgesValidationException && (errors = ((EpicBridgesValidationException)errorPayload).getValidationErrors()) != null && errors.length > 0) {
                    hl7Exception = errors[0];
                }
            }
            Message ack = hl7Msg.generateACK(this.ackCode != null ? this.ackCode.resolveValue(message).toString() : "AA", hl7Exception);
            VersionComparator comparator = new VersionComparator();
            if (errorPayload != null && errorPayload instanceof EpicBridgesValidationException && comparator.compare(hl7Msg.getVersion(), "2.5") >= 0 && (errMethod = ack.getClass().getMethod("getERR", Integer.TYPE)) != null) {
                logger.debug((Object)"Populating ERR segments...");
                HL7Exception[] errors = ((EpicBridgesValidationException)errorPayload).getValidationErrors();
                for (int i = 1; i < errors.length; ++i) {
                    Segment errSegment = (Segment)errMethod.invoke((Object)ack, i);
                    errors[i].populate(errSegment, null);
                }
            }
            logger.debug((Object)("ACK Component generated ACK Message: " + ack));
            Object newPayload = HL7FormatConverter.toDefaultEncoding(ack, defaultEncoding, ValidationLevel.STRONG.getValidationLevel().equals(this.validation.resolveValue(message)));
            event.getMessage().setPayload(newPayload);
        }
        catch (Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
        return event;
    }

    public void setAckCode(String ackCode) {
        this.ackCode = new AttributeEvaluator(ackCode);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public AttributeEvaluator getValidation() {
        return this.validation;
    }

    public void setValidation(AttributeEvaluator validation) {
        this.validation = validation;
    }
}

