/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.processors;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.ValidationLevel;
import com.mulesoft.mule.transport.epic.util.HL7FormatConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.AttributeEvaluator;

public class EpicBridgesAppendSegment
implements MessageProcessor,
Initialisable,
MuleContextAware {
    protected MuleContext muleContext;
    private AttributeEvaluator segment;
    private AttributeEvaluator segmentName;
    private AttributeEvaluator repetition;
    private AttributeEvaluator validation;
    private boolean nonStandard = false;
    private static final Log logger = LogFactory.getLog(EpicBridgesAppendSegment.class);

    public void initialise() throws InitialisationException {
        this.segment.initialize(this.muleContext.getExpressionManager());
        this.segmentName.initialize(this.muleContext.getExpressionManager());
        this.repetition.initialize(this.muleContext.getExpressionManager());
        if (this.validation != null) {
            this.validation.initialize(this.muleContext.getExpressionManager());
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage message = event.getMessage();
        Object payload = message.getPayload();
        HL7Encoding defaultEncoding = HL7FormatConverter.getHL7Encoding(payload);
        AbstractMessage hl7Payload = null;
        try {
            Message hl7Msg = HL7FormatConverter.toHAPIMessage(event.getMessage().getPayload(), ValidationLevel.STRONG.getValidationLevel().equals(this.validation.resolveValue(message)));
            hl7Payload = (AbstractMessage)hl7Msg;
        }
        catch (HL7Exception e1) {
            throw new MessagingException(event, (Throwable)e1);
        }
        try {
            Segment newSegment = null;
            if (!this.getNonStandard()) {
                String repetitionStr = (String)this.repetition.resolveValue(event.getMessage());
                newSegment = (Segment)hl7Payload.insertRepetition((String)this.segmentName.resolveValue(event.getMessage()), Integer.valueOf(repetitionStr).intValue());
            } else {
                String nonStandardName = hl7Payload.addNonstandardSegment((String)this.segmentName.resolveValue(event.getMessage()));
                logger.debug((Object)("Segment " + this.segmentName + " added as " + nonStandardName));
                newSegment = (Segment)hl7Payload.get(nonStandardName);
            }
            Object segmentValue = this.segment.resolveValue(event.getMessage());
            if (segmentValue instanceof Segment) {
                newSegment.parse(((Segment)segmentValue).encode());
            } else if (segmentValue instanceof String) {
                newSegment.parse((String)segmentValue);
            } else {
                throw new IllegalArgumentException("Unsupported type: " + segmentValue.getClass().getName() + " ; AppendSegment expects either XML/ER7 String or a HAPI Object");
            }
            Object newPayload = HL7FormatConverter.toDefaultEncoding(hl7Payload, defaultEncoding, ValidationLevel.STRONG.getValidationLevel().equals(this.validation.resolveValue(message)));
            event.getMessage().setPayload(newPayload);
        }
        catch (HL7Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
        return event;
    }

    public void setSegment(String segment) {
        this.segment = new AttributeEvaluator(segment);
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = new AttributeEvaluator(segmentName);
    }

    public void setRepetition(String repetition) {
        this.repetition = new AttributeEvaluator(repetition);
    }

    public boolean getNonStandard() {
        return this.nonStandard;
    }

    public void setNonStandard(boolean nonStandard) {
        this.nonStandard = nonStandard;
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public AttributeEvaluator getValidation() {
        return this.validation;
    }

    public void setValidation(AttributeEvaluator validation) {
        this.validation = validation;
    }
}

