/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.processors;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.CanonicalModelClassFactory;
import ca.uhn.hl7v2.util.Terser;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.StringUtils;

public class EpicBridgesCreateMessageComponent
implements FlowConstructAware,
MuleContextAware,
Disposable,
Initialisable,
Startable,
Stoppable,
MessageProcessor {
    protected static final Log logger = LogFactory.getLog(EpicBridgesCreateMessageComponent.class);
    private String fieldSeparator = "|";
    private String encodingCharacters = "^~\\&";
    private String sendingApplication = "MULE";
    private String sendingFacility;
    private String receivingApplication;
    private String receivingFacility;
    private String dateTime;
    private String messageType;
    private String triggerEvent;
    private String messageStructure;
    private String sequenceNumber;
    private String version = "2.6";
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSSSZ");

    public MuleEvent process(MuleEvent event) throws MuleException {
        try {
            if (StringUtils.isEmpty((String)this.messageStructure)) {
                this.messageStructure = this.messageType + "_" + this.triggerEvent;
            }
            logger.debug((Object)("Creating message : " + this.messageStructure));
            CanonicalModelClassFactory factory = new CanonicalModelClassFactory(this.version);
            Class messageClass = factory.getMessageClass(this.messageStructure, this.version, false);
            Message hl7Message = (Message)messageClass.newInstance();
            Terser terser = new Terser(hl7Message);
            terser.set("/MSH-1", this.fieldSeparator);
            terser.set("/MSH-2", this.encodingCharacters);
            terser.set("/MSH-3-2", this.sendingApplication);
            if (!StringUtils.isEmpty((String)this.sendingFacility)) {
                terser.set("/MSH-4-2", this.sendingFacility);
            }
            if (!StringUtils.isEmpty((String)this.receivingApplication)) {
                terser.set("/MSH-5-2", this.receivingApplication);
            }
            if (!StringUtils.isEmpty((String)this.receivingFacility)) {
                terser.set("/MSH-6-2", this.receivingFacility);
            }
            if (StringUtils.isEmpty((String)this.dateTime)) {
                this.dateTime = this.dateFormat.format(new Date());
            }
            terser.set("/MSH-7", this.dateTime);
            terser.set("/MSH-9-1", this.messageType);
            terser.set("/MSH-9-2", this.triggerEvent);
            terser.set("/MSH-9-3", this.messageStructure);
            terser.set("/MSH-12", this.version);
            event.getMessage().setPayload((Object)hl7Message);
        }
        catch (Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
        return event;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public String getEncodingCharacters() {
        return this.encodingCharacters;
    }

    public void setEncodingCharacters(String encodingCharacters) {
        this.encodingCharacters = encodingCharacters;
    }

    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public void setSendingFacility(String sendingFacility) {
        this.sendingFacility = sendingFacility;
    }

    public String getReceivingApplication() {
        return this.receivingApplication;
    }

    public void setReceivingApplication(String receivingApplication) {
        this.receivingApplication = receivingApplication;
    }

    public String getReceivingFacility() {
        return this.receivingFacility;
    }

    public void setReceivingFacility(String receivingFacility) {
        this.receivingFacility = receivingFacility;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String dateTime) {
        this.dateTime = dateTime;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getTriggerEvent() {
        return this.triggerEvent;
    }

    public void setTriggerEvent(String triggerEvent) {
        this.triggerEvent = triggerEvent;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getMessageStructure() {
        return this.messageStructure;
    }

    public void setMessageStructure(String messageStructure) {
        this.messageStructure = messageStructure;
    }

    public void stop() throws MuleException {
    }

    public void start() throws MuleException {
    }

    public void initialise() throws InitialisationException {
    }

    public void dispose() {
    }

    public void setMuleContext(MuleContext context) {
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
    }
}

