/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.processors;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.ValidationLevel;
import com.mulesoft.mule.transport.epic.util.HL7FormatConverter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.util.AttributeEvaluator;

public class EpicBridgesDeleteSegment
implements MessageProcessor,
Initialisable,
MuleContextAware {
    protected MuleContext muleContext;
    private AttributeEvaluator segmentName;
    private AttributeEvaluator repetition;
    private AttributeEvaluator validation;
    private static final Log logger = LogFactory.getLog(EpicBridgesDeleteSegment.class);

    public void initialise() throws InitialisationException {
        this.segmentName.initialize(this.muleContext.getExpressionManager());
        this.repetition.initialize(this.muleContext.getExpressionManager());
        if (this.validation != null) {
            this.validation.initialize(this.muleContext.getExpressionManager());
        }
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleMessage message = event.getMessage();
        Object payload = message.getPayload();
        HL7Encoding defaultEncoding = HL7FormatConverter.getHL7Encoding(payload);
        AbstractMessage hl7Payload = null;
        try {
            Message hl7Msg = HL7FormatConverter.toHAPIMessage(event.getMessage().getPayload(), ValidationLevel.STRONG.getValidationLevel().equals(this.validation.resolveValue(message)));
            hl7Payload = (AbstractMessage)hl7Msg;
        }
        catch (HL7Exception e1) {
            throw new MessagingException(event, (Throwable)e1);
        }
        try {
            String repetitionStr = (String)this.repetition.resolveValue(event.getMessage());
            String segmentNameStr = (String)this.segmentName.resolveValue(event.getMessage());
            if (StringUtils.equals((String)repetitionStr, (String)"*")) {
                Structure[] oldSegments = hl7Payload.getAll(segmentNameStr);
                for (int i = 0; i < oldSegments.length; ++i) {
                    Segment oldSegment = (Segment)oldSegments[i];
                    oldSegment.parse(segmentNameStr + hl7Payload.getFieldSeparatorValue());
                }
            } else {
                Segment oldSegment = (Segment)hl7Payload.get(segmentNameStr, Integer.valueOf(repetitionStr).intValue());
                oldSegment.parse(segmentNameStr + hl7Payload.getFieldSeparatorValue());
            }
            Object newPayload = HL7FormatConverter.toDefaultEncoding(hl7Payload, defaultEncoding, ValidationLevel.STRONG.getValidationLevel().equals(this.validation.resolveValue(message)));
            event.getMessage().setPayload(newPayload);
        }
        catch (HL7Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
        return event;
    }

    public void setSegmentName(String segmentName) {
        this.segmentName = new AttributeEvaluator(segmentName);
    }

    public void setRepetition(String repetition) {
        this.repetition = new AttributeEvaluator(repetition);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    public AttributeEvaluator getValidation() {
        return this.validation;
    }

    public void setValidation(AttributeEvaluator validation) {
        this.validation = validation;
    }
}

