/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.protocols;

import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.MinLLPReader;
import ca.uhn.hl7v2.llp.MinLLPWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.ResponseOutputStream;
import org.mule.api.MuleMessage;
import org.mule.transport.tcp.TcpProtocol;
import org.mule.transport.tcp.protocols.ProtocolStream;

public class HL7Protocol
implements TcpProtocol {
    public static final boolean STREAM_OK = false;
    private static final Log logger = LogFactory.getLog(HL7Protocol.class);

    public Object read(InputStream is) throws IOException {
        try {
            MinLLPReader reader = new MinLLPReader(is);
            return reader.getMessage();
        }
        catch (LLPException e) {
            logger.info((Object)"Unable to read message: ", (Throwable)e);
            throw new IOException("Unable to read or parse HL7 Message!", e);
        }
        catch (SocketException se) {
            logger.warn((Object)se.getMessage());
            return null;
        }
    }

    public void write(OutputStream os, Object data) throws IOException {
        try {
            MinLLPWriter writer = new MinLLPWriter(os);
            if (data instanceof MuleMessage) {
                writer.writeMessage(((MuleMessage)data).getPayload().toString());
            } else {
                writer.writeMessage(data.toString());
            }
        }
        catch (LLPException e) {
            logger.info((Object)"Unable to write message: ", (Throwable)e);
            throw new IOException("Unable to write HL7 Message!", e);
        }
    }

    public ResponseOutputStream createResponse(Socket socket) throws IOException {
        return new ResponseOutputStream(socket, (OutputStream)new ProtocolStream((TcpProtocol)this, false, socket.getOutputStream()));
    }
}

