/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.transformers;

import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.util.HL7FormatConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;

public class EpicBridgesDefaultInboundTransformer
extends AbstractMessageTransformer {
    private String hl7encoding;
    private boolean enableValidation = true;
    protected static final Log logger = LogFactory.getLog(EpicBridgesDefaultInboundTransformer.class);

    public String getHl7encoding() {
        return this.hl7encoding;
    }

    public void setHl7encoding(String hl7encoding) {
        this.hl7encoding = hl7encoding;
    }

    public void setEnableValidation(boolean enableValidation) {
        this.enableValidation = enableValidation;
    }

    public boolean isEnableValidation() {
        return this.enableValidation;
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            Object encodedMessage = this.convertToDefaultEncoding(message.getPayload());
            Message hapiMsg = HL7FormatConverter.toHAPIMessage(encodedMessage, this.isEnableValidation());
            Terser terser = new Terser(hapiMsg);
            DefaultMuleMessage muleMessage = (DefaultMuleMessage)message;
            if (terser.get("/MSH-9-1") != null) {
                muleMessage.setInboundProperty("hl7.messageType", (Object)terser.get("/MSH-9-1"));
            }
            if (terser.get("/MSH-9-2") != null) {
                muleMessage.setInboundProperty("hl7.triggerEvent", (Object)terser.get("/MSH-9-2"));
            }
            if (terser.get("/MSH-9-3") != null) {
                muleMessage.setInboundProperty("hl7.messageStructure", (Object)terser.get("/MSH-9-3"));
            }
            if (terser.get("/MSH-1") != null) {
                muleMessage.setInboundProperty("hl7.fieldSeparator", (Object)terser.get("/MSH-1"));
            }
            if (terser.get("/MSH-12") != null) {
                muleMessage.setInboundProperty("hl7.encodingCharacters", (Object)terser.get("/MSH-12"));
            }
            muleMessage.setInboundProperty("hl7.defaultEncoding", (Object)this.hl7encoding);
            muleMessage.setPayload(encodedMessage);
            return muleMessage;
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    private Object convertToDefaultEncoding(Object transportMessage) throws Exception {
        if (transportMessage instanceof String) {
            String hl7String = (String)transportMessage;
            if (hl7String.indexOf("?xml") != -1 && HL7Encoding.XML.toString().equalsIgnoreCase(this.hl7encoding)) {
                return hl7String;
            }
            if (hl7String.trim().startsWith("MSH|") && HL7Encoding.ER7.toString().equalsIgnoreCase(this.hl7encoding)) {
                return hl7String;
            }
            return HL7FormatConverter.toDefaultEncoding(hl7String, HL7Encoding.valueOf(this.hl7encoding), this.isEnableValidation());
        }
        return transportMessage;
    }
}

