/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.transformers;

import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.ValidationLevel;
import com.mulesoft.mule.transport.epic.util.HL7FormatConverter;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.util.AttributeEvaluator;

public class EpicBridgesEncodingTransformer
extends AbstractMessageTransformer {
    private AttributeEvaluator hl7Encoding;
    private AttributeEvaluator validation;

    public void initialise() throws InitialisationException {
        super.initialise();
        if (this.hl7Encoding != null) {
            this.hl7Encoding.initialize(this.muleContext.getExpressionManager());
        }
        if (this.validation != null) {
            this.validation.initialize(this.muleContext.getExpressionManager());
        }
    }

    public Object transformMessage(MuleMessage message, String outputEncoding) throws TransformerException {
        try {
            return HL7FormatConverter.toDefaultEncoding(message.getPayload(), HL7Encoding.valueOf((String)this.hl7Encoding.resolveValue(message)), ValidationLevel.STRONG.getValidationLevel().equals(this.validation.resolveValue(message)));
        }
        catch (Exception e) {
            throw new TransformerException((Transformer)this, (Throwable)e);
        }
    }

    public AttributeEvaluator getHl7Encoding() {
        return this.hl7Encoding;
    }

    public void setHl7Encoding(AttributeEvaluator hl7encoding) {
        this.hl7Encoding = hl7encoding;
    }

    public AttributeEvaluator getValidation() {
        return this.validation;
    }

    public void setValidation(AttributeEvaluator validation) {
        this.validation = validation;
    }
}

