/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.util;

import com.mulesoft.mule.transport.epic.util.HL7FormatConverter;
import com.mulesoft.mule.transport.epic.util.HL7v2XMLQuickParser;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class ACKGenerator {
    private static final String DEFAULTDATEFORMAT = "yyyyMMddHHmmss";
    private static Logger logger = Logger.getLogger(ACKGenerator.class);

    public static String generateAckResponse(String message, String acknowledgementCode, String textMessage) throws Exception {
        return ACKGenerator.generateAckResponse(message, acknowledgementCode, textMessage, DEFAULTDATEFORMAT, new String());
    }

    public static String generateAckResponse(String message, String acknowledgementCode, String textMessage, String dateFormat, String errorMessage) throws Exception {
        if (message == null || message.length() < 9) {
            logger.error((Object)("Unable to parse, message is null or too short: " + message));
            throw new Exception("Unable to parse, message is null or too short: " + message);
        }
        char segmentDelim = '\r';
        char fieldDelim = '|';
        char componentDelim = '^';
        char repetitionSeparator = '~';
        char escapeCharacter = '\\';
        char subcomponentDelim = '&';
        String sendingApplication = "";
        String sendingFacility = "";
        String receivingApplication = "";
        String receivingFacility = "";
        String originalEvent = "";
        String originalId = "";
        String procId = "";
        String procIdMode = "";
        String version = "";
        if ("XML".equals((Object)HL7FormatConverter.getHL7Encoding(message))) {
            HL7v2XMLQuickParser.HL7v2Header mshElements = HL7v2XMLQuickParser.getInstance().processMSH(message);
            sendingApplication = mshElements.getSendingApplication();
            sendingFacility = mshElements.getSendingFacility();
            receivingApplication = mshElements.getReceivingApplication();
            receivingFacility = mshElements.getReceivingFacility();
            originalEvent = mshElements.getOriginalEvent();
            originalId = mshElements.getOriginalId();
            procId = mshElements.getProcId();
            procIdMode = mshElements.getProcIdMode();
            version = mshElements.getVersion();
        } else {
            int firstSegmentDelim;
            fieldDelim = message.charAt(3);
            componentDelim = message.charAt(4);
            if (message.charAt(5) != fieldDelim) {
                repetitionSeparator = message.charAt(5);
                if (message.charAt(6) != fieldDelim) {
                    escapeCharacter = message.charAt(6);
                    if (message.charAt(7) != fieldDelim) {
                        subcomponentDelim = message.charAt(7);
                    }
                }
            }
            String mshString = (firstSegmentDelim = message.indexOf(String.valueOf(segmentDelim))) != -1 ? message.substring(0, firstSegmentDelim) : message;
            Pattern fieldPattern = Pattern.compile(Pattern.quote(String.valueOf(fieldDelim)));
            Pattern componentPattern = Pattern.compile(Pattern.quote(String.valueOf(componentDelim)));
            String[] mshFields = fieldPattern.split(mshString);
            int mshFieldsLength = mshFields.length;
            if (mshFieldsLength > 2) {
                sendingApplication = componentPattern.split(mshFields[2])[0];
                if (mshFieldsLength > 3) {
                    sendingFacility = componentPattern.split(mshFields[3])[0];
                    if (mshFieldsLength > 4) {
                        receivingApplication = componentPattern.split(mshFields[4])[0];
                        if (mshFieldsLength > 5) {
                            receivingFacility = componentPattern.split(mshFields[5])[0];
                            if (mshFieldsLength > 8) {
                                String[] msgDT = componentPattern.split(mshFields[8]);
                                if (msgDT.length > 1) {
                                    originalEvent = msgDT[1];
                                }
                                if (mshFieldsLength > 9) {
                                    originalId = componentPattern.split(mshFields[9])[0];
                                    if (mshFieldsLength > 10) {
                                        String[] msh11 = componentPattern.split(mshFields[10]);
                                        procId = msh11[0];
                                        if (msh11.length > 1) {
                                            procIdMode = msh11[1];
                                        }
                                        if (mshFieldsLength > 11) {
                                            version = componentPattern.split(mshFields[11])[0];
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        textMessage = textMessage != null && textMessage.length() > 0 ? fieldDelim + textMessage : new String();
        errorMessage = errorMessage != null && errorMessage.length() > 0 ? segmentDelim + "ERR" + fieldDelim + errorMessage : new String();
        if (version.length() == 0) {
            version = "2.4";
        }
        if (procId.length() == 0) {
            procId = "P";
        }
        if (originalId.length() == 0) {
            originalId = "1";
        }
        if (receivingApplication.length() == 0) {
            receivingApplication = "MULE";
        }
        Date currentDate = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat(DEFAULTDATEFORMAT);
        String timestamp = sdf.format(currentDate);
        StringBuilder ackBuilder = new StringBuilder();
        ackBuilder.append("MSH" + fieldDelim + componentDelim + repetitionSeparator + escapeCharacter + subcomponentDelim + fieldDelim);
        ackBuilder.append(receivingApplication);
        ackBuilder.append(fieldDelim);
        ackBuilder.append(receivingFacility);
        ackBuilder.append(fieldDelim);
        ackBuilder.append(sendingApplication);
        ackBuilder.append(fieldDelim);
        ackBuilder.append(sendingFacility);
        ackBuilder.append(fieldDelim);
        ackBuilder.append(timestamp);
        ackBuilder.append(fieldDelim);
        ackBuilder.append(fieldDelim);
        ackBuilder.append("ACK");
        String[] versionArray = version.split("\\.");
        if (versionArray.length > 1) {
            int majorVersion = 2;
            int minorVersion = 4;
            try {
                majorVersion = Integer.parseInt(versionArray[0]);
                minorVersion = Integer.parseInt(versionArray[1]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (majorVersion == 2 && minorVersion > 3) {
                ackBuilder.append(componentDelim);
                ackBuilder.append(originalEvent);
                ackBuilder.append(componentDelim);
                ackBuilder.append("ACK");
            }
        }
        ackBuilder.append(fieldDelim);
        ackBuilder.append(timestamp);
        ackBuilder.append(fieldDelim);
        ackBuilder.append(procId);
        if (procIdMode != null && procIdMode.length() > 0) {
            ackBuilder.append(componentDelim);
            ackBuilder.append(procIdMode);
        }
        ackBuilder.append(fieldDelim);
        ackBuilder.append(version);
        ackBuilder.append(segmentDelim);
        ackBuilder.append("MSA");
        ackBuilder.append(fieldDelim);
        ackBuilder.append(acknowledgementCode);
        ackBuilder.append(fieldDelim);
        ackBuilder.append(originalId);
        ackBuilder.append(textMessage);
        ackBuilder.append(errorMessage);
        ackBuilder.append(segmentDelim);
        return ackBuilder.toString();
    }
}

