/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import com.mulesoft.mule.transport.epic.HL7Encoding;
import com.mulesoft.mule.transport.epic.util.XMLNSParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HL7FormatConverter {
    protected static final Log logger = LogFactory.getLog(HL7FormatConverter.class);

    public static Object toDefaultEncoding(Object hl7Message, HL7Encoding encoding, boolean enableValidation) throws HL7Exception {
        logger.debug((Object)("Default encoding is " + (Object)((Object)encoding)));
        switch (encoding) {
            case ER7: {
                return HL7FormatConverter.toER7(hl7Message, enableValidation);
            }
            case XML: {
                return HL7FormatConverter.toXML(hl7Message, enableValidation);
            }
            case HAPI: {
                return HL7FormatConverter.toHAPIMessage(hl7Message, enableValidation);
            }
        }
        throw new EncodingNotSupportedException("Unsupported encoding: " + (Object)((Object)encoding));
    }

    public static String toER7(Object hl7Message, boolean enableValidation) throws HL7Exception {
        Message hapiMessage = null;
        String response = null;
        if (hl7Message instanceof String) {
            String hl7String = (String)hl7Message;
            if (hl7String.trim().startsWith("MSH|")) {
                response = hl7String;
            }
            if (hl7String.trim().startsWith("<?xml")) {
                XMLNSParser p = new XMLNSParser();
                if (!enableValidation) {
                    logger.debug((Object)"Validation disabled");
                    p.setValidationContext((ValidationContext)new NoValidation());
                }
                hapiMessage = p.parse(hl7String);
            }
        } else if (hl7Message instanceof Message) {
            hapiMessage = (Message)hl7Message;
        }
        if (hapiMessage != null) {
            GenericParser p = new GenericParser();
            if (!enableValidation) {
                logger.debug((Object)"Validation disabled");
                p.setValidationContext((ValidationContext)new NoValidation());
            }
            p.setPipeParserAsPrimary();
            response = p.encode(hapiMessage);
        }
        if (response == null) {
            throw new HL7Exception("Unsupported message: " + hl7Message, 200);
        }
        return response;
    }

    public static String toXML(Object hl7Message, boolean enableValidation) throws HL7Exception {
        Message hapiMessage = null;
        String response = null;
        if (hl7Message instanceof String) {
            String hl7String = (String)hl7Message;
            if (hl7String.trim().startsWith("<?xml")) {
                response = hl7String;
            }
            if (hl7String.trim().startsWith("MSH|")) {
                GenericParser p = new GenericParser();
                if (!enableValidation) {
                    logger.debug((Object)"Validation disabled");
                    p.setValidationContext((ValidationContext)new NoValidation());
                }
                hapiMessage = p.parse(hl7String);
            }
        } else if (hl7Message instanceof Message) {
            hapiMessage = (Message)hl7Message;
        }
        if (hapiMessage != null) {
            GenericParser p = new GenericParser();
            p.setXMLParserAsPrimary();
            response = p.encode(hapiMessage);
        }
        if (response == null) {
            throw new HL7Exception("Unsupported message: " + hl7Message, 200);
        }
        return response;
    }

    public static Message toHAPIMessage(Object hl7Message, boolean enableValidation) throws HL7Exception {
        Message response = null;
        if (hl7Message instanceof Message) {
            response = (Message)hl7Message;
        } else if (hl7Message instanceof String) {
            String payload = hl7Message.toString();
            XMLNSParser p = null;
            p = HL7FormatConverter.getHL7Encoding(hl7Message) == HL7Encoding.XML ? new XMLNSParser() : new GenericParser();
            if (!enableValidation) {
                logger.debug((Object)"Validation disabled");
                p.setValidationContext((ValidationContext)new NoValidation());
            }
            response = p.parse(payload);
        }
        if (response == null) {
            throw new HL7Exception("Unsupported message: " + hl7Message, 200);
        }
        return response;
    }

    public static HL7Encoding getHL7Encoding(Object hl7Message) {
        if (hl7Message instanceof String) {
            String hl7String = (String)hl7Message;
            if (hl7String.trim().startsWith("<?xml")) {
                return HL7Encoding.XML;
            }
            if (hl7String.trim().startsWith("MSH|")) {
                return HL7Encoding.ER7;
            }
        } else if (hl7Message instanceof Message) {
            return HL7Encoding.HAPI;
        }
        return null;
    }
}

