/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class HL7v2XMLQuickParser {
    private Logger logger = Logger.getLogger(this.getClass());
    private final String mshHeader = "MSH|^~\\&|";
    private final String fieldSeparator = "|";
    private final String componentSeparator = "^";
    private final String headerSegmentName = "MSH";
    private final Pattern headerSegmentNamePrecompiled = Pattern.compile("MSH\\s", 8);
    private final String senderAppField = "MSH.3";
    private final Pattern senderAppFieldPrecompiled = Pattern.compile("MSH\\.3\\s", 8);
    private final String senderPlaceField = "MSH.4";
    private final Pattern senderPlaceFieldPrecompiled = Pattern.compile("MSH\\.4\\s");
    private final String receiverAppField = "MSH.5";
    private final Pattern receiverAppFieldPrecompiled = Pattern.compile("MSH\\.5\\s");
    private final String receiverPlaceField = "MSH.6";
    private final Pattern receiverPlaceFieldPrecompiled = Pattern.compile("MSH\\.6\\s");
    private final String msg9Field = "MSH.9";
    private final Pattern msg9FieldPrecompiled = Pattern.compile("MSH\\.9\\s");
    private final String msgIdField = "MSH.10";
    private final Pattern msgIdPrecompiled = Pattern.compile("MSH\\.10\\s");
    private final String msgh11Field = "MSH.11";
    private final Pattern msgh11FieldPrecompiled = Pattern.compile("MSH\\.11\\s");
    private final String msgVersionField = "MSH.12";
    private final Pattern msgVersionFieldPrecompiled = Pattern.compile("MSH\\.12\\s");
    private final String procIdData = "PT.1";
    private final Pattern procIdDataPrecompiled = Pattern.compile("PT\\.1\\s");
    private final String procIdModeData = "PT.2";
    private final Pattern procIdModeDataPrecompiled = Pattern.compile("PT\\.2\\s");
    private final String msg2Data = "MSG.2";
    private final Pattern msg2DataPrecompiled = Pattern.compile("MSG\\.2\\s");
    private final String cm2Data = "CM.2";
    private final Pattern cm2DataPrecompiled = Pattern.compile("CM\\.2\\s");
    private final String msaSegmentName = "MSA";
    private final Pattern msaSegmentNamePrecompiled = Pattern.compile("MSA\\s", 8);
    private final String acknowledgmentCodeField = "MSA.1";
    private final Pattern acknowledgmentCodeFieldPrecompiled = Pattern.compile("MSA\\.1\\s", 8);
    private final String ackMessageControlIdField = "MSA.2";
    private final Pattern ackMessageControlIdFieldPrecompiled = Pattern.compile("MSA\\.2\\s", 8);
    private final String ackTextMessageField = "MSA.3";
    private final Pattern ackTextMessageFieldPrecompiled = Pattern.compile("MSA\\.3\\s", 8);
    private final String errorSegmentName = "ERR";
    private final Pattern errorSegmentNamePrecompiled = Pattern.compile("ERR\\s", 8);
    private final String errorLocationField = "ERR.1";
    private final Pattern errorLocationFieldPrecompiled = Pattern.compile("ERR\\.1\\s", 8);
    private final Pattern whiteSpacePattern = Pattern.compile("\\s");
    private final Pattern xmlElementPatternPrecompiled = Pattern.compile("</?[^>]+/?>", 8);
    private final Pattern multipleWhiteSpacePatternPrecompiled = Pattern.compile("\\s+", 8);
    private static HL7v2XMLQuickParser instance = null;

    private HL7v2XMLQuickParser() {
    }

    public static HL7v2XMLQuickParser getInstance() {
        if (instance == null) {
            instance = new HL7v2XMLQuickParser();
        }
        return instance;
    }

    private String createER7MSH(String senderApp, String senderPlace, String receiverApp, String receiverPlace, String timest, String event, String processingType, String processingMode, String msgId, String version) {
        String msh = "MSH|^~\\&|";
        msh = msh + senderApp + "|";
        msh = msh + senderPlace + "|";
        msh = msh + receiverApp + "|";
        msh = msh + receiverPlace + "|";
        msh = msh + timest + "|" + "|";
        msh = msh + "ACK^" + event + "^" + "ACK" + "|";
        msh = msh + msgId + "|";
        msh = msh + processingType;
        if (processingMode.length() > 0) {
            msh = msh + "|" + processingMode;
        }
        msh = msh + "|";
        msh = msh + version + "|";
        return msh;
    }

    private String getElementContent(String xmlInput, String elementName, Pattern precompiledPattern) {
        String msgHeader = "";
        int mshStartPos = xmlInput.indexOf(elementName + ">");
        if (mshStartPos < 0) {
            return "";
        }
        msgHeader = xmlInput.substring(mshStartPos + elementName.length() + 1);
        int mshEndPos = msgHeader.indexOf(elementName + ">");
        if (mshEndPos < 0) {
            mshEndPos = mshStartPos;
            msgHeader = xmlInput.substring(0, mshEndPos);
            Matcher m = precompiledPattern.matcher(msgHeader);
            if (!m.find()) {
                return "";
            }
            mshStartPos = m.end();
            if (mshStartPos < 0) {
                return "";
            }
            if ((mshStartPos = (msgHeader = msgHeader.substring(mshStartPos)).indexOf(">")) < 0) {
                return "";
            }
            msgHeader = msgHeader.substring(mshStartPos + 1);
            mshEndPos = msgHeader.length() - 1;
        }
        while (mshEndPos > 1 && !msgHeader.substring(mshEndPos - 1, mshEndPos).equals("<")) {
            --mshEndPos;
        }
        if (mshEndPos <= 1) {
            return "";
        }
        msgHeader = msgHeader.substring(0, mshEndPos - 1);
        return msgHeader;
    }

    private String getFirstChildContent(String xmlInput, int startPos) {
        int endPos;
        if (startPos < 0) {
            startPos = xmlInput.indexOf("<");
        }
        if (startPos != 0) {
            if (startPos < 0) {
                return xmlInput;
            }
            String content = xmlInput.substring(0, startPos);
            if (content.trim().length() > 0) {
                return content;
            }
        }
        if ((endPos = xmlInput.indexOf(">")) <= 0) {
            return "";
        }
        if (xmlInput.substring(endPos - 1, endPos + 1).equals("/>")) {
            return "";
        }
        String elementName = xmlInput.substring(startPos + 1, endPos);
        Matcher m = this.whiteSpacePattern.matcher(elementName);
        if (m.find()) {
            elementName = elementName.substring(0, m.start());
        }
        startPos = endPos + 1;
        endPos = xmlInput.lastIndexOf("</" + elementName + ">");
        if (endPos < 0) {
            this.logger.error((Object)("Error parsing XML as an HL7 document: can't find </" + elementName + "> in the string " + xmlInput));
            return "";
        }
        if ((startPos = (xmlInput = xmlInput.substring(startPos, endPos)).indexOf("<")) < 0) {
            return xmlInput;
        }
        return this.getFirstChildContent(xmlInput, startPos);
    }

    public HL7v2Header processMSH(String xmlInput) {
        HL7v2Header msh = new HL7v2Header();
        try {
            String mshHeader = this.getElementContent(xmlInput, "MSH", this.headerSegmentNamePrecompiled);
            msh.setSendingApplication(this.getFirstChildContent(this.getElementContent(mshHeader, "MSH.3", this.senderAppFieldPrecompiled), -1).trim());
            msh.setSendingFacility(this.getFirstChildContent(this.getElementContent(mshHeader, "MSH.4", this.senderPlaceFieldPrecompiled), -1).trim());
            msh.setReceivingApplication(this.getFirstChildContent(this.getElementContent(mshHeader, "MSH.5", this.receiverAppFieldPrecompiled), -1).trim());
            msh.setReceivingFacility(this.getFirstChildContent(this.getElementContent(mshHeader, "MSH.6", this.receiverPlaceFieldPrecompiled), -1).trim());
            msh.setOriginalId(this.getFirstChildContent(this.getElementContent(mshHeader, "MSH.10", this.msgIdPrecompiled), -1).trim());
            msh.setVersion(this.getFirstChildContent(this.getElementContent(mshHeader, "MSH.12", this.msgVersionFieldPrecompiled), -1).trim());
            String msh9 = this.getElementContent(mshHeader, "MSH.9", this.msg9FieldPrecompiled).trim();
            if (msh9.indexOf("MSG.2") > 0) {
                msh.setOriginalEvent(this.getElementContent(msh9, "MSG.2", this.msg2DataPrecompiled).trim());
            } else if (msh9.indexOf("CM.2") > 0) {
                msh.setOriginalEvent(this.getElementContent(msh9, "CM.2", this.cm2DataPrecompiled).trim());
            }
            String msh11 = this.getElementContent(mshHeader, "MSH.11", this.msgh11FieldPrecompiled);
            msh.setProcId(this.getElementContent(msh11, "PT.1", this.procIdDataPrecompiled).trim());
            msh.setProcIdMode(this.getElementContent(msh11, "PT.2", this.procIdModeDataPrecompiled).trim());
        }
        catch (Throwable t) {
            this.logger.error((Object)("Error extracting HL7 from XML in the string " + t + " input string: " + xmlInput));
        }
        return msh;
    }

    public HL7v2Header processMSA(String xmlInput) {
        HL7v2Header msh = new HL7v2Header();
        try {
            String msaSegment = this.getElementContent(xmlInput, "MSA", this.msaSegmentNamePrecompiled);
            if (msaSegment == null || msaSegment.length() == 0) {
                msh.setParseError("No MSA segment found in message");
                return msh;
            }
            msh.setAcknowledgmentCode(this.getFirstChildContent(this.getElementContent(msaSegment, "MSA.1", this.acknowledgmentCodeFieldPrecompiled), -1).trim());
            msh.setAckMessageControlId(this.getFirstChildContent(this.getElementContent(msaSegment, "MSA.2", this.ackMessageControlIdFieldPrecompiled), -1).trim());
            msh.setAckTextMessage(this.getFirstChildContent(this.getElementContent(msaSegment, "MSA.3", this.ackTextMessageFieldPrecompiled), -1).trim());
            String errorSegment = this.getElementContent(xmlInput, "ERR", this.errorSegmentNamePrecompiled);
            if (errorSegment != null && errorSegment.length() > 0) {
                msh.setERRFullSegment(errorSegment);
                String errorDesc = this.getElementContent(errorSegment, "ERR.1", this.errorLocationFieldPrecompiled);
                errorDesc = this.xmlElementPatternPrecompiled.matcher(errorDesc).replaceAll(":");
                errorDesc = this.multipleWhiteSpacePatternPrecompiled.matcher(errorDesc).replaceAll(" ");
                msh.setError(errorDesc);
            }
        }
        catch (Throwable t) {
            this.logger.error((Object)("Error extracting HL7 from XML in the string " + t + " input string: " + xmlInput));
        }
        return msh;
    }

    public class HL7v2Header {
        String sendingApplication = "Unknown";
        String sendingFacility = "Unknown";
        String receivingApplication = "MULE";
        String receivingFacility = "MULE";
        String originalEvent = "ACK";
        String originalId = "123456789";
        String procId = "P";
        String procIdMode = "";
        String version = "2.4";
        String acknowledgmentCode = "CE";
        String ackMessageControlId = "Unknown";
        String ackTextMessage = "Not valid ACK";
        String error = null;
        String parseError = null;
        String fullSegment = "ERR";

        public String toString() {
            return HL7v2XMLQuickParser.this.createER7MSH(this.sendingApplication, this.sendingFacility, this.receivingApplication, this.receivingFacility, "2001111111111", this.originalEvent, this.procId, this.procIdMode, this.originalId, this.version);
        }

        public String getSendingApplication() {
            return this.sendingApplication;
        }

        public void setSendingApplication(String sendingApplication) {
            this.sendingApplication = sendingApplication;
        }

        public String getSendingFacility() {
            return this.sendingFacility;
        }

        public void setSendingFacility(String sendingFacility) {
            this.sendingFacility = sendingFacility;
        }

        public String getReceivingApplication() {
            return this.receivingApplication;
        }

        public void setReceivingApplication(String receivingApplication) {
            this.receivingApplication = receivingApplication;
        }

        public String getReceivingFacility() {
            return this.receivingFacility;
        }

        public void setReceivingFacility(String receivingFacility) {
            this.receivingFacility = receivingFacility;
        }

        public String getOriginalEvent() {
            return this.originalEvent;
        }

        public void setOriginalEvent(String originalEvent) {
            this.originalEvent = originalEvent;
        }

        public String getOriginalId() {
            return this.originalId;
        }

        public void setOriginalId(String originalId) {
            this.originalId = originalId;
        }

        public String getProcId() {
            return this.procId;
        }

        public void setProcId(String procId) {
            this.procId = procId;
        }

        public String getProcIdMode() {
            return this.procIdMode;
        }

        public void setProcIdMode(String procIdMode) {
            this.procIdMode = procIdMode;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getAcknowledgmentCode() {
            return this.acknowledgmentCode;
        }

        public void setAcknowledgmentCode(String acknowledgmentCode) {
            this.acknowledgmentCode = acknowledgmentCode;
        }

        public String getAckMessageControlId() {
            return this.ackMessageControlId;
        }

        public void setAckMessageControlId(String ackMessageControlId) {
            this.ackMessageControlId = ackMessageControlId;
        }

        public String getAckTextMessage() {
            return this.ackTextMessage;
        }

        public void setAckTextMessage(String ackTextMessage) {
            this.ackTextMessage = ackTextMessage;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }

        public String getParseError() {
            return this.parseError;
        }

        public void setParseError(String parseError) {
            this.parseError = parseError;
        }

        public String getERRFullSegment() {
            return this.fullSegment;
        }

        public void setERRFullSegment(String fullSegment) {
            this.fullSegment = fullSegment;
        }
    }
}

