/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.util;

import java.util.Comparator;

public class VersionComparator
implements Comparator {
    public boolean equals(Object o1, Object o2) {
        return this.compare(o1, o2) == 0;
    }

    public int compare(Object o1, Object o2) {
        String version1 = (String)o1;
        String version2 = (String)o2;
        VersionTokenizer tokenizer1 = new VersionTokenizer(version1);
        VersionTokenizer tokenizer2 = new VersionTokenizer(version2);
        int number1 = 0;
        int number2 = 0;
        String suffix1 = "";
        String suffix2 = "";
        while (tokenizer1.moveNext()) {
            boolean empty2;
            if (!tokenizer2.moveNext()) {
                do {
                    number1 = tokenizer1.getNumber();
                    suffix1 = tokenizer1.getSuffix();
                    if (number1 == 0 && suffix1.length() == 0) continue;
                    return 1;
                } while (tokenizer1.moveNext());
                return 0;
            }
            number1 = tokenizer1.getNumber();
            suffix1 = tokenizer1.getSuffix();
            number2 = tokenizer2.getNumber();
            suffix2 = tokenizer2.getSuffix();
            if (number1 < number2) {
                return -1;
            }
            if (number1 > number2) {
                return 1;
            }
            boolean empty1 = suffix1.length() == 0;
            boolean bl = empty2 = suffix2.length() == 0;
            if (empty1 && empty2) continue;
            if (empty1) {
                return 1;
            }
            if (empty2) {
                return -1;
            }
            int result = suffix1.compareTo(suffix2);
            if (result == 0) continue;
            return result;
        }
        if (tokenizer2.moveNext()) {
            do {
                number2 = tokenizer2.getNumber();
                suffix2 = tokenizer2.getSuffix();
                if (number2 == 0 && suffix2.length() == 0) continue;
                return -1;
            } while (tokenizer2.moveNext());
            return 0;
        }
        return 0;
    }

    class VersionTokenizer {
        private final String _versionString;
        private final int _length;
        private int _position;
        private int _number;
        private String _suffix;
        private boolean _hasValue;

        public int getNumber() {
            return this._number;
        }

        public String getSuffix() {
            return this._suffix;
        }

        public VersionTokenizer(String versionString) {
            if (versionString == null) {
                throw new IllegalArgumentException("versionString is null");
            }
            this._versionString = versionString;
            this._length = versionString.length();
        }

        public boolean moveNext() {
            char c;
            char c2;
            this._number = 0;
            this._suffix = "";
            this._hasValue = false;
            if (this._position >= this._length) {
                return false;
            }
            this._hasValue = true;
            while (this._position < this._length && (c2 = this._versionString.charAt(this._position)) >= '0' && c2 <= '9') {
                this._number = this._number * 10 + (c2 - 48);
                ++this._position;
            }
            int suffixStart = this._position;
            while (this._position < this._length && (c = this._versionString.charAt(this._position)) != '.') {
                ++this._position;
            }
            this._suffix = this._versionString.substring(suffixStart, this._position);
            if (this._position < this._length) {
                ++this._position;
            }
            return true;
        }
    }
}

