/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.transport.epic.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.GenericMessage;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.util.Terser;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.StandardParserConfiguration;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLNSParser
extends Parser {
    private static final Log logger = LogFactory.getLog(XMLNSParser.class);
    private DOMParser parser = new DOMParser((XMLParserConfiguration)new StandardParserConfiguration());
    private String textEncoding;
    private String[] keepAsOriginalNodes;
    private String concatKeepAsOriginalNodes = "";
    private static final Set<String> ourForceGroupNames = new HashSet<String>();

    public XMLNSParser() {
        this(null);
    }

    public XMLNSParser(ModelClassFactory theFactory) {
        super(theFactory);
        try {
            this.parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
        }
        catch (Exception e) {
            logger.error((Object)"Can't exclude whitespace from XML DOM", (Throwable)e);
        }
    }

    public String getEncoding(String message) {
        if (this.isXmlEncoded(message)) {
            return "XML";
        }
        return null;
    }

    public boolean supportsEncoding(String encoding) {
        return encoding != null && encoding.equals("XML");
    }

    public String getDefaultEncoding() {
        return "XML";
    }

    public void setKeepAsOriginalNodes(String[] keepAsOriginalNodes) {
        this.keepAsOriginalNodes = keepAsOriginalNodes;
        if (keepAsOriginalNodes.length != 0) {
            StringBuffer strBuf = new StringBuffer(keepAsOriginalNodes[0]);
            for (int i = 1; i < keepAsOriginalNodes.length; ++i) {
                strBuf.append("|");
                strBuf.append(keepAsOriginalNodes[i]);
            }
            this.concatKeepAsOriginalNodes = strBuf.toString();
        } else {
            this.concatKeepAsOriginalNodes = "";
        }
    }

    public String[] getKeepAsOriginalNodes() {
        return this.keepAsOriginalNodes;
    }

    protected Message doParse(String message, String version) throws HL7Exception, EncodingNotSupportedException {
        Message m = null;
        Document doc = null;
        doc = this.parseStringIntoDocument(message);
        m = this.parseDocument(doc, version);
        return m;
    }

    protected synchronized Document parseStringIntoDocument(String message) throws HL7Exception {
        try {
            this.parser.parse(new InputSource(new StringReader(message)));
        }
        catch (SAXException e) {
            throw new HL7Exception("SAXException parsing XML", 207, (Throwable)e);
        }
        catch (IOException e) {
            throw new HL7Exception("IOException parsing XML", 207, (Throwable)e);
        }
        Document doc = this.parser.getDocument();
        return doc;
    }

    protected String doEncode(Message source, String encoding) throws HL7Exception, EncodingNotSupportedException {
        if (!encoding.equals("XML")) {
            throw new EncodingNotSupportedException("XMLParser supports only XML encoding");
        }
        return this.encode(source);
    }

    protected String doEncode(Message source) throws HL7Exception {
        if (source instanceof GenericMessage) {
            throw new HL7Exception("Can't XML-encode a GenericMessage.  Message must have a recognized structure.");
        }
        Document doc = this.encodeDocument(source);
        Element documentElement = doc.getDocumentElement();
        documentElement.setAttribute("xmlns", "urn:hl7-org:v2xml");
        StringWriter out = new StringWriter();
        OutputFormat outputFormat = new OutputFormat("", null, true);
        outputFormat.setLineWidth(0);
        if (this.textEncoding != null) {
            outputFormat.setEncoding(this.textEncoding);
        }
        XMLSerializer ser = new XMLSerializer((Writer)out, outputFormat);
        try {
            ser.serialize(doc);
        }
        catch (IOException e) {
            throw new HL7Exception("IOException serializing XML document to string", 207, (Throwable)e);
        }
        return out.toString();
    }

    public void parse(Segment segmentObject, Element segmentElement) throws HL7Exception {
        HashSet<String> done = new HashSet<String>();
        NodeList all = segmentElement.getChildNodes();
        for (int i = 0; i < all.getLength(); ++i) {
            String elementName = all.item(i).getLocalName();
            if (all.item(i).getNodeType() != 1 || done.contains(elementName)) continue;
            done.add(elementName);
            int index = elementName.indexOf(46);
            if (index >= 0 && elementName.length() > index) {
                String fieldNumString = elementName.substring(index + 1);
                int fieldNum = Integer.parseInt(fieldNumString);
                this.parseReps(segmentObject, segmentElement, elementName, fieldNum);
                continue;
            }
            logger.debug((Object)("Child of segment {} doesn't look like a field {} " + segmentObject.getName() + " " + elementName));
        }
        if (segmentObject.getClass().getName().indexOf("OBX") >= 0) {
            Varies.fixOBX5((Segment)segmentObject, (ModelClassFactory)this.getFactory());
        }
    }

    private void parseReps(Segment segmentObject, Element segmentElement, String fieldName, int fieldNum) throws DataTypeException, HL7Exception {
        NodeList reps = segmentElement.getElementsByTagNameNS("*", fieldName);
        for (int i = 0; i < reps.getLength(); ++i) {
            this.parse(segmentObject.getField(fieldNum, i), (Element)reps.item(i));
        }
    }

    public boolean encode(Segment segmentObject, Element segmentElement) throws HL7Exception {
        boolean hasValue = false;
        int n = segmentObject.numFields();
        for (int i = 1; i <= n; ++i) {
            String name = this.makeElementName(segmentObject, i);
            Type[] reps = segmentObject.getField(i);
            for (int j = 0; j < reps.length; ++j) {
                Element newNode = segmentElement.getOwnerDocument().createElement(name);
                boolean componentHasValue = this.encode(reps[j], newNode);
                if (!componentHasValue) continue;
                try {
                    segmentElement.appendChild(newNode);
                }
                catch (DOMException e) {
                    throw new HL7Exception("DOMException encoding Segment: ", 207, (Throwable)e);
                }
                hasValue = true;
            }
        }
        return hasValue;
    }

    public void parse(Type datatypeObject, Element datatypeElement) throws DataTypeException {
        if (datatypeObject instanceof Varies) {
            this.parseVaries((Varies)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Primitive) {
            this.parsePrimitive((Primitive)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Composite) {
            this.parseComposite((Composite)datatypeObject, datatypeElement);
        }
    }

    private void parseVaries(Varies datatypeObject, Element datatypeElement) throws DataTypeException {
        if (!this.hasChildElement(datatypeElement)) {
            datatypeObject.setData((Type)new GenericPrimitive(datatypeObject.getMessage()));
        } else {
            datatypeObject.setData((Type)new GenericComposite(datatypeObject.getMessage()));
        }
        this.parse(datatypeObject.getData(), datatypeElement);
    }

    private boolean hasChildElement(Element e) {
        NodeList children = e.getChildNodes();
        boolean hasElement = false;
        for (int c = 0; c < children.getLength() && !hasElement; ++c) {
            if (children.item(c).getNodeType() != 1) continue;
            hasElement = true;
        }
        return hasElement;
    }

    private void parsePrimitive(Primitive datatypeObject, Element datatypeElement) throws DataTypeException {
        NodeList children = datatypeElement.getChildNodes();
        int c = 0;
        boolean full = false;
        while (c < children.getLength() && !full) {
            Node child;
            if ((child = children.item(c++)).getNodeType() != 3) continue;
            try {
                if (child.getNodeValue() != null && !child.getNodeValue().equals("")) {
                    if (this.keepAsOriginal(child.getParentNode())) {
                        datatypeObject.setValue(child.getNodeValue());
                    } else {
                        datatypeObject.setValue(this.removeWhitespace(child.getNodeValue()));
                    }
                }
            }
            catch (DOMException e) {
                logger.error((Object)"Error parsing primitive value from TEXT_NODE", (Throwable)e);
            }
            full = true;
        }
    }

    protected boolean keepAsOriginal(Node node) {
        if (node.getLocalName() == null) {
            return false;
        }
        return this.concatKeepAsOriginalNodes.indexOf(node.getLocalName()) != -1;
    }

    protected String removeWhitespace(String s) {
        s = s.replace('\r', ' ');
        s = s.replace('\n', ' ');
        s = s.replace('\t', ' ');
        boolean repeatedSpacesExist = true;
        while (repeatedSpacesExist) {
            int loc = s.indexOf("  ");
            if (loc < 0) {
                repeatedSpacesExist = false;
                continue;
            }
            StringBuffer buf = new StringBuffer();
            buf.append(s.substring(0, loc));
            buf.append(" ");
            buf.append(s.substring(loc + 2));
            s = buf.toString();
        }
        return s.trim();
    }

    private void parseComposite(Composite datatypeObject, Element datatypeElement) throws DataTypeException {
        if (datatypeObject instanceof GenericComposite) {
            NodeList children = datatypeElement.getChildNodes();
            int compNum = 0;
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                Element nextElement = (Element)children.item(i);
                String localName = nextElement.getLocalName();
                int dotIndex = localName.indexOf(".");
                if (dotIndex > -1) {
                    compNum = Integer.parseInt(localName.substring(dotIndex + 1)) - 1;
                } else {
                    logger.debug((Object)("Datatype element {} doesn't have a valid numbered name, usgin default index of {} " + datatypeElement.getLocalName() + " " + compNum));
                }
                Type nextComponent = datatypeObject.getComponent(compNum);
                this.parse(nextComponent, nextElement);
                ++compNum;
            }
        } else {
            Type[] children = datatypeObject.getComponents();
            for (int i = 0; i < children.length; ++i) {
                NodeList matchingElements = datatypeElement.getElementsByTagNameNS("*", this.makeElementName(datatypeObject, i + 1));
                if (matchingElements.getLength() <= 0) continue;
                this.parse(children[i], (Element)matchingElements.item(0));
            }
        }
    }

    private String makeElementName(Segment s, int child) {
        return s.getName() + "." + child;
    }

    private String makeElementName(Composite composite, int child) {
        return composite.getName() + "." + child;
    }

    private boolean encode(Type datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasData = false;
        if (datatypeObject instanceof Varies) {
            hasData = this.encodeVaries((Varies)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Primitive) {
            hasData = this.encodePrimitive((Primitive)datatypeObject, datatypeElement);
        } else if (datatypeObject instanceof Composite) {
            hasData = this.encodeComposite((Composite)datatypeObject, datatypeElement);
        }
        return hasData;
    }

    private boolean encodeVaries(Varies datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasData = false;
        if (datatypeObject.getData() != null) {
            hasData = this.encode(datatypeObject.getData(), datatypeElement);
        }
        return hasData;
    }

    private boolean encodePrimitive(Primitive datatypeObject, Element datatypeElement) throws DataTypeException {
        boolean hasValue = false;
        if (datatypeObject.getValue() != null && !datatypeObject.getValue().equals("")) {
            hasValue = true;
        }
        Text t = datatypeElement.getOwnerDocument().createTextNode(datatypeObject.getValue());
        if (hasValue) {
            try {
                datatypeElement.appendChild(t);
            }
            catch (DOMException e) {
                throw new DataTypeException("DOMException encoding Primitive: ", (Throwable)e);
            }
        }
        return hasValue;
    }

    private boolean encodeComposite(Composite datatypeObject, Element datatypeElement) throws DataTypeException {
        Type[] components = datatypeObject.getComponents();
        boolean hasValue = false;
        for (int i = 0; i < components.length; ++i) {
            String name = this.makeElementName(datatypeObject, i + 1);
            Element newNode = datatypeElement.getOwnerDocument().createElement(name);
            boolean componentHasValue = this.encode(components[i], newNode);
            if (!componentHasValue) continue;
            try {
                datatypeElement.appendChild(newNode);
            }
            catch (DOMException e) {
                throw new DataTypeException("DOMException encoding Composite: ", (Throwable)e);
            }
            hasValue = true;
        }
        return hasValue;
    }

    public Segment getCriticalResponseData(String message) throws HL7Exception {
        String version = this.getVersion(message);
        Segment criticalData = Parser.makeControlMSH((String)version, (ModelClassFactory)this.getFactory());
        Terser.set((Segment)criticalData, (int)1, (int)0, (int)1, (int)1, (String)this.parseLeaf(message, "MSH.1", 0));
        Terser.set((Segment)criticalData, (int)2, (int)0, (int)1, (int)1, (String)this.parseLeaf(message, "MSH.2", 0));
        Terser.set((Segment)criticalData, (int)10, (int)0, (int)1, (int)1, (String)this.parseLeaf(message, "MSH.10", 0));
        String procID = this.parseLeaf(message, "MSH.11", 0);
        if (procID == null || procID.length() == 0) {
            procID = this.parseLeaf(message, "PT.1", message.indexOf("MSH.11"));
        }
        Terser.set((Segment)criticalData, (int)11, (int)0, (int)1, (int)1, (String)procID);
        return criticalData;
    }

    public String getAckID(String message) {
        String ackID = null;
        try {
            ackID = this.parseLeaf(message, "msa.2", 0).trim();
        }
        catch (HL7Exception hL7Exception) {
            // empty catch block
        }
        return ackID;
    }

    public String getVersion(String message) throws HL7Exception {
        String version = this.parseLeaf(message, "MSH.12", 0);
        if (version == null || version.trim().length() == 0) {
            version = this.parseLeaf(message, "VID.1", message.indexOf("MSH.12"));
        }
        return version;
    }

    protected String parseLeaf(String message, String tagName, int startAt) throws HL7Exception {
        String value = null;
        int tagStart = message.indexOf("<" + tagName, startAt);
        if (tagStart < 0) {
            tagStart = message.indexOf("<" + tagName.toUpperCase(), startAt);
        }
        if (tagStart < 0) {
            tagStart = startAt + XMLNSParser.indexOfRegex("<[^/].*?:" + tagName, message.substring(startAt));
        }
        if (tagStart < 0) {
            tagStart = startAt + XMLNSParser.indexOfRegex("<[^/].*?:" + tagName, message.substring(startAt));
        }
        int valStart = message.indexOf(">", tagStart) + 1;
        int valEnd = message.indexOf("<", valStart);
        if (tagStart < 0 || valEnd < valStart) {
            throw new HL7Exception("Couldn't find " + tagName + " in message beginning: " + message.substring(0, Math.min(150, message.length())), 101);
        }
        value = message.substring(valStart, valEnd);
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&apos;", "'");
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        return value;
    }

    public static int indexOfRegex(String pattern, String content) {
        int position = -1;
        Pattern p = Pattern.compile(pattern);
        Matcher m = p.matcher(content);
        if (m.find()) {
            position = m.start();
        }
        return position;
    }

    public String doEncode(Segment structure, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected Message doParseForSpecificPackage(String theMessage, String theVersion, String thePackageName) throws HL7Exception, EncodingNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String doEncode(Type type, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(Type type, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void parse(Segment segment, String string, EncodingCharacters encodingCharacters) throws HL7Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getTextEncoding() {
        return this.textEncoding;
    }

    public void setTextEncoding(String textEncoding) {
        this.textEncoding = textEncoding;
    }

    public Document encodeDocument(Message source) throws HL7Exception {
        String messageClassName = source.getClass().getName();
        String messageName = messageClassName.substring(messageClassName.lastIndexOf(46) + 1);
        Document doc = null;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = doc.createElement(messageName);
            doc.appendChild(root);
        }
        catch (Exception e) {
            throw new HL7Exception("Can't create XML document - " + e.getClass().getName(), 207, (Throwable)e);
        }
        this.encode((Group)source, doc.getDocumentElement());
        return doc;
    }

    private void encode(Group groupObject, Element groupElement) throws HL7Exception {
        String[] childNames = groupObject.getNames();
        String messageName = groupObject.getMessage().getName();
        try {
            for (int i = 0; i < childNames.length; ++i) {
                Structure[] reps = groupObject.getAll(childNames[i]);
                for (int j = 0; j < reps.length; ++j) {
                    Element childElement;
                    String elementName = XMLNSParser.makeGroupElementName(messageName, childNames[i]);
                    try {
                        childElement = groupElement.getOwnerDocument().createElement(elementName);
                    }
                    catch (DOMException e) {
                        throw new HL7Exception("Can't encode element " + elementName + " in group " + groupObject.getClass().getName(), 207, (Throwable)e);
                    }
                    groupElement.appendChild(childElement);
                    if (reps[j] instanceof Group) {
                        this.encode((Group)reps[j], childElement);
                        continue;
                    }
                    if (!(reps[j] instanceof Segment)) continue;
                    this.encode((Segment)reps[j], childElement);
                }
            }
        }
        catch (DOMException e) {
            throw new HL7Exception("Can't encode group " + groupObject.getClass().getName(), 207, (Throwable)e);
        }
    }

    public Message parseDocument(Document XMLMessage, String version) throws HL7Exception {
        String messageName = XMLMessage.getDocumentElement().getLocalName();
        Message message = this.instantiateMessage(messageName, version, true);
        this.parse((Group)message, XMLMessage.getDocumentElement());
        return message;
    }

    private void parse(Group groupObject, Element groupElement) throws HL7Exception {
        int i;
        String[] childNames = groupObject.getNames();
        String messageName = groupObject.getMessage().getName();
        NodeList allChildNodes = groupElement.getChildNodes();
        ArrayList<String> unparsedElementList = new ArrayList<String>();
        for (i = 0; i < allChildNodes.getLength(); ++i) {
            Node node = allChildNodes.item(i);
            String name = node.getLocalName();
            if (node.getNodeType() != 1 || unparsedElementList.contains(name)) continue;
            unparsedElementList.add(name);
        }
        for (i = 0; i < childNames.length; ++i) {
            unparsedElementList.remove(childNames[i]);
            if (childNames[i].length() != 4) {
                this.parseReps(groupElement, groupObject, messageName, childNames[i], childNames[i]);
                continue;
            }
            logger.debug((Object)("Skipping rep segment: {} " + childNames[i]));
        }
        for (i = 0; i < unparsedElementList.size(); ++i) {
            String segName = (String)unparsedElementList.get(i);
            String segIndexName = groupObject.addNonstandardSegment(segName);
            this.parseReps(groupElement, groupObject, messageName, segName, segIndexName);
        }
    }

    private void parseReps(Element groupElement, Group groupObject, String messageName, String childName, String childIndexName) throws HL7Exception {
        block7: {
            List<Element> reps;
            block6: {
                reps = this.getChildElementsByTagName(groupElement, XMLNSParser.makeGroupElementName(messageName, childName));
                logger.debug((Object)("# of elements matching {}: {} " + XMLNSParser.makeGroupElementName(messageName, childName) + " " + reps.size()));
                if (!groupObject.isRepeating(childIndexName)) break block6;
                for (int i = 0; i < reps.size(); ++i) {
                    this.parseRep(reps.get(i), groupObject.get(childIndexName, i));
                }
                break block7;
            }
            if (reps.size() > 0) {
                this.parseRep(reps.get(0), groupObject.get(childIndexName, 0));
            }
            if (reps.size() <= 1) break block7;
            String newIndexName = "";
            int i = 1;
            try {
                for (i = 1; i < reps.size(); ++i) {
                    newIndexName = childName + (i + 1);
                    Structure st = groupObject.get(newIndexName);
                    this.parseRep(reps.get(i), st);
                }
            }
            catch (Throwable t) {
                logger.info((Object)("Issue Parsing: " + t));
                newIndexName = groupObject.addNonstandardSegment(childName);
                for (int j = i; j < reps.size(); ++j) {
                    this.parseRep(reps.get(j), groupObject.get(newIndexName, j - i));
                }
            }
        }
    }

    private void parseRep(Element theElem, Structure theObj) throws HL7Exception {
        if (theObj instanceof Group) {
            this.parse((Group)theObj, theElem);
        } else if (theObj instanceof Segment) {
            this.parse((Segment)theObj, theElem);
        }
        logger.debug((Object)("Parsed element: {} " + theElem.getLocalName()));
    }

    private List<Element> getChildElementsByTagName(Element theElement, String theName) {
        ArrayList<Element> result = new ArrayList<Element>(10);
        NodeList children = theElement.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getLocalName().equals(theName)) continue;
            result.add((Element)child);
        }
        return result;
    }

    protected static String makeGroupElementName(String messageName, String className) {
        String ret = null;
        if (className.length() > 4 || ourForceGroupNames.contains(className)) {
            StringBuilder elementName = new StringBuilder();
            elementName.append(messageName);
            elementName.append('.');
            elementName.append(className);
            ret = elementName.toString();
        } else {
            ret = className.length() == 4 ? className.substring(0, 3) : className;
        }
        return ret;
    }

    public void parse(Message theMessage, String theString) throws HL7Exception {
        Document doc = this.parseStringIntoDocument(theString);
        this.parse((Group)theMessage, doc.getDocumentElement());
    }

    public boolean isXmlEncoded(String theMessage) {
        String[] expected = new String[]{"(?s).*<([0-9a-zA-Z][-\\w]*:)?MSH\\.1.*", "(?s).*<([0-9a-zA-Z][-\\w]*:)?MSH\\.2.*", "(?s).*</([0-9a-zA-Z][-\\w]*:)?MSH>.*"};
        for (int i = 0; i < expected.length; ++i) {
            if (theMessage.matches(expected[i])) continue;
            return false;
        }
        return true;
    }

    static {
        ourForceGroupNames.add("DIET");
    }
}

