/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

package com.mulesoft.datamapper.test.functional;

import com.mulesoft.mule.module.datamapper.api.GraphExecutorFactory;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperExecutionException;
import com.mulesoft.mule.module.datamapper.clover.CloverEngineConfig;
import com.mulesoft.mule.module.datamapper.clover.SimpleCloverGraphExecutorFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractDataMapperFunctionalTest
{


    private GraphExecutorFactory executorFactory;

    @Before
    public void before() throws Exception
    {
        executorFactory = createGraphExecutorFactory();
        executorFactory.init();
    }

    protected GraphExecutorFactory createGraphExecutorFactory()
    {
        return new SimpleCloverGraphExecutorFactoryImpl(UUID.randomUUID().toString(), new CloverEngineManager(CloverEngineConfig.createDefault(), new ConcurrentHashMap<String, CloverEngineImpl>()));

    }

    @After
    public void after()
    {
        executorFactory.dispose();
    }

    public <U, T> void runMappingWithInputAndExpect(String mappingPath, U value, Map<String, Object> inputArguments, T expect) throws DataMapperCreationException, DataMapperExecutionException
    {

        final Object execute = runMapping(mappingPath, value, inputArguments);
        TestCase.assertEquals(execute, execute);
    }

    protected <U> Object runMapping(String mappingPath, U value, Map<String, Object> inputArguments) throws DataMapperExecutionException, DataMapperCreationException
    {
        final String mappingFilePath = CloverEngineConfig.class.getClassLoader().getResource(mappingPath).getFile();
        return executorFactory.createGraphExecutor(mappingFilePath).execute(value, inputArguments).getPayload();
    }


    protected Object runMapping(String mappingPath, Object payload) throws DataMapperExecutionException, DataMapperCreationException
    {
        return runMapping(mappingPath,payload,new HashMap<String, Object>());
    }

}
