/**
 *
 * (c) 2011 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */
package com.mulesoft.datamapper.test.integration;

import com.mulesource.licm.EnterpriseLicenseKey;
import org.junit.BeforeClass;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.config.MuleProperties;
import org.mule.construct.Flow;
import org.mule.module.reboot.TestLicenseManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.FunctionalTestCase;

import java.io.File;
import java.net.URL;
import java.util.Properties;

import static org.junit.Assert.assertEquals;

public abstract class DataMapperIntegrationTestCase extends FunctionalTestCase {

    public static final String CLOVER_GRAPH_PATH = "clover_graph_path";

    public abstract String getTransformationGraph();


    @BeforeClass
    public static void setupLicense() {
        EnterpriseLicenseKey licenseKey = Mockito.mock(EnterpriseLicenseKey.class);
        Mockito.when(licenseKey.isEvaluation()).thenReturn(true);
        new TestLicenseManager().setLicenseKey(licenseKey);
    }

    @Override
    protected Properties getStartUpProperties() {
        Properties properties = new Properties(super.getStartUpProperties());
        URL resource = Thread.currentThread().getContextClassLoader().getResource(getTransformationGraph());
        assert resource != null;
        File graphFile = new File(resource.getFile());
        properties.put(CLOVER_GRAPH_PATH, graphFile.getName());
        properties.put(MuleProperties.APP_HOME_DIRECTORY_PROPERTY, graphFile.getParentFile().getAbsolutePath());

        return properties;
    }


    /**
     * Run the flow specified by name and assert equality on the expected output
     *
     * @param flowName The name of the flow to run
     * @param expect   The expected output
     */
    protected <T> void runFlowAndExpect(String flowName, T expect) throws Exception {
        Flow flow = lookupFlowConstruct(flowName);
        MuleEvent event = getTestEvent(null);

        MuleEvent responseEvent = flow.process(event);

        assertEquals(expect, responseEvent.getMessage().getPayload());
    }

    /**
     * Run the flow specified by name using the specified payload and assert
     * equality on the expected output
     *
     * @param flowName The name of the flow to run
     * @param expect   The expected output
     * @param payload  The payload of the input event
     */
    protected <T, U> void runFlowWithPayloadAndExpect(String flowName, T expect, U payload) throws Exception {
        Flow flow = lookupFlowConstruct(flowName);
        MuleEvent event = getTestEvent(payload);
        MuleEvent responseEvent = flow.process(event);

        assertEquals(expect, responseEvent.getMessage().getPayload());
    }

    /**
     * Retrieve a flow by name from the registry
     *
     * @param name Name of the flow to retrieve
     */
    protected Flow lookupFlowConstruct(String name) {
        return (Flow) AbstractMuleContextTestCase.muleContext.getRegistry().lookupFlowConstruct(name);
    }
}
