/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.test.functional;

import com.mulesoft.mule.module.datamapper.api.GraphExecutorFactory;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperExecutionException;
import com.mulesoft.mule.module.datamapper.clover.CloverEngineConfig;
import com.mulesoft.mule.module.datamapper.clover.SimpleCloverGraphExecutorFactoryImpl;
import com.mulesoft.mule.module.datamapper.clover.impl.CloverEngineManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataMapperFunctionalTest {
    private GraphExecutorFactory executorFactory;

    @Before
    public void before() throws Exception {
        this.executorFactory = this.createGraphExecutorFactory();
        this.executorFactory.init();
    }

    protected GraphExecutorFactory createGraphExecutorFactory() {
        return new SimpleCloverGraphExecutorFactoryImpl(UUID.randomUUID().toString(), new CloverEngineManager(CloverEngineConfig.createDefault(), new ConcurrentHashMap()));
    }

    @After
    public void after() {
        this.executorFactory.dispose();
    }

    public <U, T> void runMappingWithInputAndExpect(String mappingPath, U value, Map<String, Object> inputArguments, T expect) throws DataMapperCreationException, DataMapperExecutionException {
        Object execute = this.runMapping(mappingPath, value, inputArguments);
        TestCase.assertEquals((Object)execute, (Object)execute);
    }

    protected <U> Object runMapping(String mappingPath, U value, Map<String, Object> inputArguments) throws DataMapperExecutionException, DataMapperCreationException {
        String mappingFilePath = CloverEngineConfig.class.getClassLoader().getResource(mappingPath).getFile();
        return this.executorFactory.createGraphExecutor(mappingFilePath).execute(value, inputArguments).getPayload();
    }

    protected Object runMapping(String mappingPath, Object payload) throws DataMapperExecutionException, DataMapperCreationException {
        return this.runMapping(mappingPath, payload, new HashMap<String, Object>());
    }
}

