/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.test.integration;

import com.mulesource.licm.EnterpriseLicenseKey;
import java.io.File;
import java.net.URL;
import java.util.Properties;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.reboot.TestLicenseManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.FunctionalTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataMapperIntegrationTestCase
extends FunctionalTestCase {
    public static final String CLOVER_GRAPH_PATH = "clover_graph_path";

    public abstract String getTransformationGraph();

    @BeforeClass
    public static void setupLicense() {
        EnterpriseLicenseKey licenseKey = (EnterpriseLicenseKey)Mockito.mock(EnterpriseLicenseKey.class);
        Mockito.when((Object)licenseKey.isEvaluation()).thenReturn((Object)true);
        new TestLicenseManager().setLicenseKey(licenseKey);
    }

    protected Properties getStartUpProperties() {
        Properties properties = new Properties(super.getStartUpProperties());
        URL resource = Thread.currentThread().getContextClassLoader().getResource(this.getTransformationGraph());
        assert (resource != null);
        File graphFile = new File(resource.getFile());
        properties.put(CLOVER_GRAPH_PATH, graphFile.getName());
        properties.put("app.home", graphFile.getParentFile().getAbsolutePath());
        return properties;
    }

    protected <T> void runFlowAndExpect(String flowName, T expect) throws Exception {
        Flow flow = this.lookupFlowConstruct(flowName);
        MuleEvent event = DataMapperIntegrationTestCase.getTestEvent(null);
        MuleEvent responseEvent = flow.process(event);
        Assert.assertEquals(expect, (Object)responseEvent.getMessage().getPayload());
    }

    protected <T, U> void runFlowWithPayloadAndExpect(String flowName, T expect, U payload) throws Exception {
        Flow flow = this.lookupFlowConstruct(flowName);
        MuleEvent event = DataMapperIntegrationTestCase.getTestEvent(payload);
        MuleEvent responseEvent = flow.process(event);
        Assert.assertEquals(expect, (Object)responseEvent.getMessage().getPayload());
    }

    protected Flow lookupFlowConstruct(String name) {
        return (Flow)AbstractMuleContextTestCase.muleContext.getRegistry().lookupFlowConstruct(name);
    }
}

