/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.lookup;


import com.mulesoft.mule.module.datamapper.util.DataRecordFactory;
import com.mulesoft.mule.module.datamapper.util.DataRecordUtils;

import org.jetel.data.DataRecord;
import org.jetel.data.RecordKey;
import org.jetel.data.lookup.Lookup;
import org.jetel.data.lookup.LookupTable;

public class MuleFlowLookup implements Lookup
{

    private MuleFlowLookupTable lookupTable;
    private RecordKey key;
    private MuleFlowRefAdaptor connector;
    private DataRecord value;

    public MuleFlowLookup(MuleFlowLookupTable lookupTable, RecordKey key, MuleFlowRefAdaptor connector)
    {
        this.lookupTable = lookupTable;
        this.key = key;
        this.connector = connector;

    }


    public LookupTable getLookupTable()
    {
        return lookupTable;
    }

    public RecordKey getKey()
    {
        return key;
    }

    public void seek()
    {
        seek(null);
    }

    public void seek(DataRecord dataFields)
    {
        if (value == null)
        {
            final Object[] values = new DataRecordUtils().getValues(dataFields);
            final Object lookupResult = connector.lookup(values);
            value = lookupResult != null ? new DataRecordFactory().buildFrom(lookupTable.getMetadata(), lookupResult) : null;
        }
    }

    public int getNumFound()
    {
        return value == null ? 0 : 1;
    }

    public boolean hasNext()
    {
        return value != null;
    }

    public DataRecord next()
    {
        final DataRecord result = value;
        value = null;
        return result;
    }

    public void remove()
    {

    }
}
