/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.lookup;

import com.mulesoft.datamapper.mule.DefaultMuleContextAccessor;
import com.mulesoft.mule.module.datamapper.DataMapperModule;
import org.jetel.graph.dictionary.Dictionary;

public class MuleFlowRefAdaptorFactory {

    public static MuleFlowRefAdaptor createMuleFlowAdaptor(String[] keys, String flowName, Dictionary dictionary) {

        if (dictionary.getValue(DataMapperModule.MULE_CONTEXT) != null &&  dictionary.getValue(DataMapperModule.MULE_EVENT) != null) {
            return new MuleFlowRefAdaptorImpl(keys, flowName, new DefaultMuleContextAccessor(dictionary));
        }else{
            return new PreviewMuleFlowRefAdaptorImpl();
        }
    }
}
