/**
 *
 * (c) 2012 MuleSoft, Inc. This software is protected under international copyright
 * law. All use of this software is subject to MuleSoft's Master Subscription Agreement
 * (or other master license agreement) separately entered into in writing between you and
 * MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package com.mulesoft.datamapper.lookup;


import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.client.DefaultLocalMuleClient;

import com.mulesoft.datamapper.mule.MuleContextAccessor;

import java.util.HashMap;
import java.util.Map;


public class MuleFlowRefAdaptorImpl implements MuleFlowRefAdaptor
{

    private String[] keys;
    private String flowName;
    private MuleContextAccessor muleContextAccessor;


    public MuleFlowRefAdaptorImpl(String[] keys, String flowName, MuleContextAccessor muleContextAccessor)
    {
        this.keys = keys;
        this.flowName = flowName;
        this.muleContextAccessor = muleContextAccessor;
    }

    @Override
    public Object lookup(Object[] values)
    {
        final Map<String, Object> argument = buildMap(values);
        MuleMessage message = muleContextAccessor.getMuleEvent() != null ? muleContextAccessor.getMuleEvent().getMessage() : null;
        final MuleMessage muleMessage = new DefaultMuleMessage(argument, message, muleContextAccessor.getMuleContext());
        final MessageProcessor referencedMessageProcessor = getReferencedMessageProcessor(flowName);
        final MuleEvent muleEvent = createMuleEvent(muleMessage, MessageExchangePattern.REQUEST_RESPONSE);
        try
        {
            final MuleEvent process = referencedMessageProcessor.process(muleEvent);
            return process.getMessage().getPayload();
        }
        catch (MuleException e)
        {
            throw new RuntimeException(e);
        }

    }

    private Map<String, Object> buildMap(Object[] values)
    {
        final Map<String, Object> argument = new HashMap<String, Object>();
        for (int i = 0; i < values.length; i++)
        {
            Object value = values[i];
            argument.put(getKeys()[i], value);
        }
        return argument;
    }

    protected MuleEvent createMuleEvent(MuleMessage message, MessageExchangePattern exchangePattern)
    {
        return new DefaultMuleEvent(message, exchangePattern, new DefaultLocalMuleClient.MuleClientFlowConstruct(
                muleContextAccessor.getMuleContext()));
    }

    protected MessageProcessor getReferencedMessageProcessor(String name)
    {
        final MessageProcessor processor = muleContextAccessor.getMuleContext().getRegistry().get(name);
        if (processor == null)
        {
            throw new MuleFlowLookupException("Flow Name '" + name + "' was not found");
        }
        return processor;
    }


    //PROPERTIES OF FLOWS
    public void setFlowName(String flowName)
    {
        this.flowName = flowName;
    }

    public String[] getKeys()
    {
        return keys;
    }

    public void setKeys(String[] keys)
    {
        this.keys = keys;
    }
}
