/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.function;

import com.mulesoft.datamapper.transform.function.Calendar2DateFunction;
import com.mulesoft.datamapper.transform.function.Calendar2LongFunction;
import com.mulesoft.datamapper.transform.function.Calendar2NumFunction;
import com.mulesoft.datamapper.transform.function.Calendar2StrFunction;
import com.mulesoft.datamapper.transform.function.Date2CalendarFunction;
import com.mulesoft.datamapper.transform.function.Long2CalendarFunction;
import com.mulesoft.datamapper.transform.function.Str2CalendarFunction;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.time.DateUtils;
import org.jetel.ctl.Stack;
import org.jetel.ctl.extensions.TLFunctionAnnotation;
import org.jetel.ctl.extensions.TLFunctionCallContext;
import org.jetel.ctl.extensions.TLFunctionLibrary;
import org.jetel.ctl.extensions.TLFunctionPrototype;

public class CalendarLib
extends TLFunctionLibrary {
    public String getName() {
        return "Calendar";
    }

    public TLFunctionPrototype getExecutable(String functionName) {
        if (functionName.equals("calendar2date")) {
            return new Calendar2DateCTLFunction();
        }
        if (functionName.equals("calendar2long")) {
            return new Calendar2LongCTLFunction();
        }
        if (functionName.equals("calendar2str")) {
            return new Calendar2StrCTLFunction();
        }
        if (functionName.equals("calendar2number")) {
            return new Calendar2NumCTLFunction();
        }
        if (functionName.equals("long2calendar")) {
            return new Long2CalendarCTLFunction();
        }
        if (functionName.equals("date2calendar")) {
            return new Date2CalendarCTLFunction();
        }
        if (functionName.equals("str2calendar")) {
            return new Str2CalendarCTLFunction();
        }
        throw new IllegalArgumentException("Unknown function '" + functionName + "'");
    }

    @TLFunctionAnnotation(value="Transforms a calendar to a date.")
    public static Date calendar2date(TLFunctionCallContext context, String calendar) {
        return Calendar2DateFunction.calendarToDate((String)calendar);
    }

    @TLFunctionAnnotation
    public static Long calendar2long(TLFunctionCallContext context, String calendar) {
        return Calendar2LongFunction.calendarToLong((String)calendar);
    }

    @TLFunctionAnnotation
    public static String calendar2str(TLFunctionCallContext context, String calendar, String pattern) {
        return Calendar2StrFunction.calendarToStr((String)calendar, (String)pattern);
    }

    @TLFunctionAnnotation
    public static Integer calendar2number(TLFunctionCallContext context, String calendar, Integer unit) {
        return Calendar2NumFunction.calendarToNumber((String)calendar, (Integer)unit);
    }

    @TLFunctionAnnotation
    public static String long2calendar(TLFunctionCallContext context, Long milliseconds) {
        return Long2CalendarFunction.longToCalendar((Long)milliseconds, (TimeZone)DateUtils.UTC_TIME_ZONE);
    }

    @TLFunctionAnnotation
    public static String long2calendar(TLFunctionCallContext context, Long milliseconds, String timeZone) {
        return Long2CalendarFunction.longToCalendar((Long)milliseconds, (TimeZone)TimeZone.getTimeZone(timeZone));
    }

    @TLFunctionAnnotation
    public static String date2calendar(TLFunctionCallContext context, Date date) {
        return Date2CalendarFunction.dateToCalendar((Date)date, (TimeZone)DateUtils.UTC_TIME_ZONE);
    }

    @TLFunctionAnnotation
    public static String date2calendar(TLFunctionCallContext context, Date date, String timeZone) {
        return Date2CalendarFunction.dateToCalendar((Date)date, (TimeZone)TimeZone.getTimeZone(timeZone));
    }

    @TLFunctionAnnotation
    public static String str2calendar(TLFunctionCallContext context, String calendarString, String pattern) {
        return Str2CalendarFunction.stringToCalendar((String)calendarString, (String)pattern, (TimeZone)DateUtils.UTC_TIME_ZONE);
    }

    @TLFunctionAnnotation
    public static String str2calendar(TLFunctionCallContext context, String calendarString, String pattern, String timeZone) {
        return Str2CalendarFunction.stringToCalendar((String)calendarString, (String)pattern, (TimeZone)TimeZone.getTimeZone(timeZone));
    }

    public class Str2CalendarCTLFunction
    implements TLFunctionPrototype {
        public void init(TLFunctionCallContext context) {
        }

        public void execute(Stack stack, TLFunctionCallContext context) {
            if (context.getParams().length == 2) {
                stack.push((Object)CalendarLib.str2calendar(context, stack.popString(), stack.popString()));
            } else {
                stack.push((Object)CalendarLib.str2calendar(context, stack.popString(), stack.popString(), stack.popString()));
            }
        }
    }

    public class Date2CalendarCTLFunction
    implements TLFunctionPrototype {
        public void init(TLFunctionCallContext context) {
        }

        public void execute(Stack stack, TLFunctionCallContext context) {
            if (context.getParams().length == 1) {
                stack.push((Object)CalendarLib.date2calendar(context, stack.popDate()));
            } else {
                stack.push((Object)CalendarLib.date2calendar(context, stack.popDate(), stack.popString()));
            }
        }
    }

    public class Long2CalendarCTLFunction
    implements TLFunctionPrototype {
        public void init(TLFunctionCallContext context) {
        }

        public void execute(Stack stack, TLFunctionCallContext context) {
            if (context.getParams().length == 1) {
                stack.push((Object)CalendarLib.long2calendar(context, stack.popLong()));
            } else {
                stack.push((Object)CalendarLib.long2calendar(context, stack.popLong(), stack.popString()));
            }
        }
    }

    public class Calendar2StrCTLFunction
    implements TLFunctionPrototype {
        public void init(TLFunctionCallContext context) {
        }

        public void execute(Stack stack, TLFunctionCallContext context) {
            stack.push((Object)CalendarLib.calendar2str(context, stack.popString(), stack.popString()));
        }
    }

    public class Calendar2NumCTLFunction
    implements TLFunctionPrototype {
        public void init(TLFunctionCallContext context) {
        }

        public void execute(Stack stack, TLFunctionCallContext context) {
            stack.push((Object)CalendarLib.calendar2number(context, stack.popString(), stack.popInt()));
        }
    }

    public class Calendar2LongCTLFunction
    implements TLFunctionPrototype {
        public void init(TLFunctionCallContext context) {
        }

        public void execute(Stack stack, TLFunctionCallContext context) {
            stack.push((Object)CalendarLib.calendar2long(context, stack.popString()));
        }
    }

    public class Calendar2DateCTLFunction
    implements TLFunctionPrototype {
        public void init(TLFunctionCallContext context) {
        }

        public void execute(Stack stack, TLFunctionCallContext context) {
            stack.push((Object)CalendarLib.calendar2date(context, stack.popString()));
        }
    }
}

