/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.datamapper.lookup;

import com.mulesoft.datamapper.lookup.MuleFlowLookup;
import com.mulesoft.datamapper.lookup.MuleFlowRefAdaptorFactory;
import java.util.Iterator;
import org.jetel.data.DataRecord;
import org.jetel.data.Defaults;
import org.jetel.data.HashKey;
import org.jetel.data.RecordKey;
import org.jetel.data.lookup.Lookup;
import org.jetel.data.lookup.LookupTable;
import org.jetel.exception.AttributeNotFoundException;
import org.jetel.exception.ComponentNotReadyException;
import org.jetel.exception.ConfigurationProblem;
import org.jetel.exception.ConfigurationStatus;
import org.jetel.exception.GraphConfigurationException;
import org.jetel.exception.NotInitializedException;
import org.jetel.exception.XMLConfigurationException;
import org.jetel.graph.GraphElement;
import org.jetel.graph.IGraphElement;
import org.jetel.graph.TransformationGraph;
import org.jetel.metadata.DataRecordMetadata;
import org.jetel.util.primitive.TypedProperties;
import org.jetel.util.property.ComponentXMLAttributes;
import org.jetel.util.string.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MuleFlowLookupTable
extends GraphElement
implements LookupTable {
    private static final String XML_LOOKUP_KEY = "key";
    private static final String XML_FLOW_REF = "flow-ref";
    private static final String XML_LOOKUP_TYPE_FLOW_REF_LOOKUP = "muleFlowLookup";
    private static final String[] REQUESTED_ATTRIBUTE = new String[]{"id", "type", "metadata", "key", "flow-ref"};
    private String metadataName;
    private DataRecordMetadata metadata;
    private String[] keys;
    private RecordKey indexKey;
    private String flowRefName;

    public MuleFlowLookupTable(String id, String metadataName, String[] keys, String flowRefName) {
        super(id);
        this.flowRefName = flowRefName;
        this.setMetadataName(metadataName);
        this.setKeys(keys);
    }

    public boolean isPutSupported() {
        return false;
    }

    public boolean isRemoveSupported() {
        return false;
    }

    public DataRecordMetadata getMetadata() {
        return this.metadata;
    }

    public DataRecordMetadata getKeyMetadata() throws ComponentNotReadyException {
        if (!this.isInitialized()) {
            throw new NotInitializedException((IGraphElement)this);
        }
        return this.getIndexKey().generateKeyRecordMetadata();
    }

    public boolean put(DataRecord dataFields) {
        return false;
    }

    public boolean remove(DataRecord dataFields) {
        return false;
    }

    public boolean remove(HashKey hashKey) {
        return false;
    }

    public Lookup createLookup(RecordKey recordKey) throws ComponentNotReadyException {
        return new MuleFlowLookup(this, recordKey, MuleFlowRefAdaptorFactory.createMuleFlowAdaptor(this.getKeys(), this.getFlowRefName(), this.getGraph().getDictionary()));
    }

    public Lookup createLookup(RecordKey recordKey, DataRecord dataFields) throws ComponentNotReadyException {
        return new MuleFlowLookup(this, recordKey, MuleFlowRefAdaptorFactory.createMuleFlowAdaptor(this.getKeys(), this.getFlowRefName(), this.getGraph().getDictionary()));
    }

    public void setCurrentPhase(int phase) {
    }

    public Iterator<DataRecord> iterator() {
        return null;
    }

    public synchronized void init() throws ComponentNotReadyException {
        if (this.isInitialized()) {
            return;
        }
        super.init();
        if (this.getMetadata() == null) {
            this.setMetadata(this.getGraph().getDataRecordMetadata(this.getMetadataName(), true));
        }
        if (this.getMetadata() == null) {
            throw new ComponentNotReadyException("Metadata " + StringUtils.quote((CharSequence)this.getMetadataName()) + " does not exist!!!");
        }
        if (this.getIndexKey() == null) {
            this.setIndexKey(new RecordKey(this.getKeys(), this.getMetadata()));
        }
        this.getIndexKey().init();
        this.getIndexKey().setEqualNULLs(true);
    }

    public ConfigurationStatus checkConfig(ConfigurationStatus status) {
        super.checkConfig(status);
        if (this.getMetadata() == null) {
            this.setMetadata(this.getGraph().getDataRecordMetadata(this.getMetadataName(), false));
        }
        if (this.getIndexKey() == null) {
            this.setIndexKey(new RecordKey(this.getKeys(), this.getMetadata()));
        }
        try {
            this.getIndexKey().init();
        }
        catch (NullPointerException e) {
            status.add((Object)new ConfigurationProblem("Key metadata are null.", ConfigurationStatus.Severity.WARNING, (IGraphElement)this, ConfigurationStatus.Priority.NORMAL, XML_LOOKUP_KEY));
            this.setIndexKey(null);
        }
        catch (RuntimeException e) {
            status.add((Object)new ConfigurationProblem(e.getMessage(), ConfigurationStatus.Severity.ERROR, (IGraphElement)this, ConfigurationStatus.Priority.NORMAL, XML_LOOKUP_KEY));
        }
        return status;
    }

    public static MuleFlowLookupTable fromProperties(TypedProperties properties) throws AttributeNotFoundException, GraphConfigurationException {
        for (String property : REQUESTED_ATTRIBUTE) {
            if (properties.containsKey((Object)property)) continue;
            throw new AttributeNotFoundException(property);
        }
        String type = properties.getStringProperty("type");
        if (!type.equalsIgnoreCase(XML_LOOKUP_TYPE_FLOW_REF_LOOKUP)) {
            throw new GraphConfigurationException("Can't create simple lookup table from type " + type);
        }
        String[] keys = properties.getStringProperty(XML_LOOKUP_KEY).split(Defaults.Component.KEY_FIELDS_DELIMITER_REGEX);
        String metadata = properties.getStringProperty("metadata");
        String flowName = properties.getStringProperty(XML_FLOW_REF);
        MuleFlowLookupTable lookupTable = new MuleFlowLookupTable(properties.getStringProperty("id"), metadata, keys, flowName);
        if (properties.containsKey((Object)"name")) {
            lookupTable.setName(properties.getStringProperty("name"));
        }
        return lookupTable;
    }

    public static MuleFlowLookupTable fromXML(TransformationGraph graph, Element nodeXML) throws XMLConfigurationException {
        String type;
        String id;
        ComponentXMLAttributes xattribs = new ComponentXMLAttributes(nodeXML, graph);
        MuleFlowLookupTable lookupTable = null;
        try {
            id = xattribs.getString("id");
            type = xattribs.getString("type");
        }
        catch (AttributeNotFoundException ex) {
            throw new XMLConfigurationException("Can't create lookup table - " + ex.getMessage(), (Throwable)ex);
        }
        if (!type.equalsIgnoreCase(XML_LOOKUP_TYPE_FLOW_REF_LOOKUP)) {
            throw new XMLConfigurationException("Can't create simple lookup table from type " + type);
        }
        try {
            String[] keys = xattribs.getString(XML_LOOKUP_KEY).split(Defaults.Component.KEY_FIELDS_DELIMITER_REGEX);
            String flowName = xattribs.getString(XML_FLOW_REF);
            String metadata = xattribs.getString("metadata");
            lookupTable = new MuleFlowLookupTable(id, metadata, keys, flowName);
            lookupTable.setGraph(graph);
            if (xattribs.exists("name")) {
                lookupTable.setName(xattribs.getString("name"));
            }
            return lookupTable;
        }
        catch (Exception ex) {
            throw new XMLConfigurationException("can't create simple lookup table", (Throwable)ex);
        }
    }

    public String getMetadataName() {
        return this.metadataName;
    }

    public void setMetadataName(String metadataName) {
        this.metadataName = metadataName;
    }

    public void setMetadata(DataRecordMetadata metadata) {
        this.metadata = metadata;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public RecordKey getIndexKey() {
        return this.indexKey;
    }

    public void setIndexKey(RecordKey indexKey) {
        this.indexKey = indexKey;
    }

    public String getFlowRefName() {
        return this.flowRefName;
    }

    public void setFlowRefName(String flowRefName) {
        this.flowRefName = flowRefName;
    }
}

