/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.internal.InvokerTestTimeSupplier;
import com.mulesoft.mq.restclient.internal.MessagePreserver;
import com.mulesoft.mq.restclient.internal.TestDestination;
import com.mulesoft.mq.restclient.internal.TestMessage;
import com.mulesoft.mq.restclient.internal.TestScheduledExecutorService;
import com.mulesoft.mq.restclient.internal.TimeSupplier;
import java.util.concurrent.ScheduledExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MessagePreserverTestCase {
    private TestDestination testDestination;
    private MessagePreserver preserver;
    private InvokerTestTimeSupplier timeSupplier;

    @Before
    public void setup() {
        boolean startTime = false;
        TestScheduledExecutorService executorService = new TestScheduledExecutorService();
        this.timeSupplier = new InvokerTestTimeSupplier(0L, executorService);
        this.testDestination = new TestDestination(this.timeSupplier);
        this.preserver = this.createPreserver(this.testDestination, this.timeSupplier, executorService);
    }

    @Test
    public void addedMessagesShouldBePreserved() {
        TestMessage message = MessagePreserverTestCase.createTestMessage("0");
        this.preserver.add((AnypointMqMessage)message, 10000L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)0));
        this.timeSupplier.addMillisecondsRealTime(1000L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)0));
        this.timeSupplier.addMillisecondsRealTime(6999L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)0));
        this.timeSupplier.addMillisecondsRealTime(2L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(MessagePreserverTestCase.id("0")), (Matcher)Is.is((Object)1));
        this.timeSupplier.addMillisecondsRealTime(8500L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(MessagePreserverTestCase.id("0")), (Matcher)Is.is((Object)2));
    }

    @Test
    public void removedMessagesShouldNotBePreservedAnymore() {
        TestMessage message = MessagePreserverTestCase.createTestMessage("0");
        this.preserver.add((AnypointMqMessage)message, 10000L);
        this.timeSupplier.addMillisecondsRealTime(8001L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        this.preserver.remove(MessagePreserverTestCase.id("0"));
        this.timeSupplier.addMillisecondsRealTime(8500L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
        this.timeSupplier.addMillisecondsRealTime(17000L);
        Assert.assertThat((Object)this.testDestination.getModifyLockIntervalCount(), (Matcher)Is.is((Object)1));
    }

    private static TestMessage createTestMessage(String suffix) {
        return new TestMessage(MessagePreserverTestCase.id(suffix), "body-" + suffix);
    }

    private static String id(String suffix) {
        return "id-" + suffix;
    }

    private MessagePreserver createPreserver(Destination destination, TimeSupplier timeSupplier, final ScheduledExecutorService executorService) {
        return new MessagePreserver(destination, timeSupplier){

            protected ScheduledExecutorService createExecutorService() {
                return executorService;
            }
        };
    }
}

