/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.internal.InvokerTestTimeSupplier;
import com.mulesoft.mq.restclient.internal.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.internal.TestDestination;
import com.mulesoft.mq.restclient.internal.TestMessage;
import com.mulesoft.mq.restclient.internal.TestScheduledExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;

public class ScheduledPrefetcherTest {
    private static final long START_TIME = 0L;
    private int batchSize;
    private long poolingTime;
    private long lockTimeToLive;
    private InvokerTestTimeSupplier timeSupplier;
    private TestDestination destination;
    private ScheduledPrefetcher prefetcher;

    @Before
    public void setup() {
        this.batchSize = 100;
        this.poolingTime = 0L;
        this.lockTimeToLive = 120000L;
        TestScheduledExecutorService executorService = new TestScheduledExecutorService();
        this.timeSupplier = new InvokerTestTimeSupplier(0L, executorService);
        this.destination = new TestDestination(this.timeSupplier);
        this.prefetcher = this.createPrefetcher(this.destination, this.batchSize, this.poolingTime, this.lockTimeToLive, executorService);
    }

    @Test
    public void retrieveMessagesOnStart() {
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)this.destination.getLastReceiveTime(), (Matcher)Matchers.is((Object)-1L));
        this.timeSupplier.addMilliseconds(1L);
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.destination.getLastReceiveTime(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void retrieveMessagePeriodically() {
        MatcherAssert.assertThat((Object)this.destination.getLastReceiveTime(), (Matcher)Matchers.is((Object)-1L));
        this.timeSupplier.addMilliseconds(5000L);
        MatcherAssert.assertThat((Object)this.destination.getLastReceiveTime(), (Matcher)Matchers.is((Object)this.timeSupplier.get()));
        this.timeSupplier.addMilliseconds(5000L);
        MatcherAssert.assertThat((Object)this.destination.getLastReceiveTime(), (Matcher)Matchers.is((Object)this.timeSupplier.get()));
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void prefetcherActsLikeAQueue() {
        this.destination.send(ScheduledPrefetcherTest.createTestMessage("1"));
        this.destination.send(ScheduledPrefetcherTest.createTestMessage("2"));
        this.destination.send(ScheduledPrefetcherTest.createTestMessage("3"));
        this.destination.send(ScheduledPrefetcherTest.createTestMessage("4"));
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)"id-1"));
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)"id-2"));
        MatcherAssert.assertThat((Object)((AnypointMqMessage)this.prefetcher.get().toBlocking().first()).getId(), (Matcher)Matchers.is((Object)"id-3"));
        MatcherAssert.assertThat((Object)this.destination.getReceiveCount(), (Matcher)Matchers.is((Object)1));
    }

    private static AnypointMqMessage createTestMessage(String id) {
        return new TestMessage("id-" + id, "body-" + id);
    }

    private ScheduledPrefetcher createPrefetcher(Destination destination, int batchSize, long poolingTime, long lockTimeToLive, final ScheduledExecutorService executorService) {
        return new ScheduledPrefetcher(destination, batchSize, poolingTime, lockTimeToLive){

            protected ScheduledExecutorService createExecutorService() {
                return executorService;
            }
        };
    }
}

