/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.internal;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.CourierObserver;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.api.LockedMessage;
import com.mulesoft.mq.restclient.api.MessageIdResult;
import com.mulesoft.mq.restclient.internal.TimeSupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class MessagePreserver {
    private static final int PRESERVE_INTERVAL = 500;
    private final Map<String, InternalPreservedMessage> preservedMessages = new ConcurrentHashMap<String, InternalPreservedMessage>();
    private final ScheduledExecutorService preserver;
    private final TimeSupplier timeSupplier;

    public MessagePreserver(final Destination destination, TimeSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
        this.preserver = this.createExecutorService();
        this.preserver.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                long now = MessagePreserver.this.now();
                ArrayList<LockedMessage> messagesToUpdate = new ArrayList<LockedMessage>();
                for (InternalPreservedMessage preservedMessage : MessagePreserver.this.preservedMessages.values()) {
                    if (!preservedMessage.isAboutToExpire(now)) continue;
                    messagesToUpdate.add(new LockedMessage(preservedMessage.message, preservedMessage.ttl));
                }
                if (MessagePreserver.this.notEmpty(messagesToUpdate)) {
                    destination.modifyLockInterval(messagesToUpdate).subscribe(new CourierObserver<List<MessageIdResult>>(){

                        @Override
                        public void onSuccess(List<MessageIdResult> messageIdResults) {
                            long now = MessagePreserver.this.now();
                            for (MessageIdResult messageIdResult : messageIdResults) {
                                if (!messageIdResult.isSuccess()) continue;
                                MessagePreserver.this.update(messageIdResult.getMessageId(), now);
                            }
                        }

                        @Override
                        public void onError(Throwable e) {
                        }
                    });
                }
            }
        }, 0L, 500L, TimeUnit.MILLISECONDS);
    }

    protected ScheduledExecutorService createExecutorService() {
        return Executors.newScheduledThreadPool(3);
    }

    public void add(List<AnypointMqMessage> messages, long ttl) {
        for (AnypointMqMessage message : messages) {
            this.add(message, ttl);
        }
    }

    public void add(AnypointMqMessage message, long ttl) {
        this.preservedMessages.put(message.getId(), new InternalPreservedMessage(message, ttl, this.now()));
    }

    public void remove(String messageId) {
        this.preservedMessages.remove(messageId);
    }

    private boolean notEmpty(List<?> messages) {
        return messages != null && messages.size() > 0;
    }

    private long now() {
        return this.timeSupplier.get();
    }

    private void update(String messageId, long now) {
        InternalPreservedMessage preservedMessage = this.preservedMessages.get(messageId);
        if (preservedMessage != null) {
            preservedMessage.update(now);
        }
    }

    private static class InternalPreservedMessage {
        private static final double MIN_TOLERANCE = 0.8;
        private final AnypointMqMessage message;
        private final long ttl;
        private long lastUpdate;

        public InternalPreservedMessage(AnypointMqMessage message, long ttl, long now) {
            this.message = message;
            this.ttl = ttl;
            this.update(now);
        }

        public void update(long now) {
            this.lastUpdate = now;
        }

        public boolean isAboutToExpire(long now) {
            return (double)(now - this.lastUpdate) > (double)this.ttl * 0.8;
        }

        public boolean isExpired(long now) {
            return now - this.lastUpdate > this.ttl;
        }
    }
}

