/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mq.restclient.impl;

import com.mulesoft.mq.restclient.api.AnypointMqMessage;
import com.mulesoft.mq.restclient.api.Destination;
import com.mulesoft.mq.restclient.impl.PrefetchedDestination;
import com.mulesoft.mq.restclient.internal.Prefetcher;
import com.mulesoft.mq.restclient.internal.ScheduledPrefetcher;
import com.mulesoft.mq.restclient.internal.TestDestination;
import com.mulesoft.mq.restclient.internal.TestMessage;
import com.mulesoft.mq.restclient.internal.TestTimeSupplier;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PrefetchedDestinationTestCase {
    private TestDestination testDestination;
    private PrefetchedDestination prefetchedDestination;
    private ScheduledExecutorService executorService;
    private ScheduledPrefetcher prefetcher;

    @Before
    public void setup() {
        boolean startTime = false;
        int batchSize = 3;
        long pollingTime = 1000L;
        long lockTimeToLive = 120000L;
        this.testDestination = new TestDestination(new TestTimeSupplier(0L));
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.prefetcher = this.createPrefetcher(this.testDestination, 3, 1000L, 120000L, this.executorService);
        this.prefetchedDestination = new PrefetchedDestination((Destination)this.testDestination, (Prefetcher)this.prefetcher);
    }

    @After
    public void tearDown() {
        this.prefetcher.stop();
        this.executorService.shutdownNow();
    }

    @Test
    public void retrieveMessagesOnlyOnceManyGets() {
        this.prefetchedDestination.send(PrefetchedDestinationTestCase.createTestMessage("0"));
        this.prefetchedDestination.send(PrefetchedDestinationTestCase.createTestMessage("1"));
        this.prefetchedDestination.send(PrefetchedDestinationTestCase.createTestMessage("2"));
        this.prefetcher.start();
        Assert.assertThat((Object)((AnypointMqMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getId(), (Matcher)Matchers.is((Object)"id-0"));
        Assert.assertThat((Object)((AnypointMqMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getId(), (Matcher)Matchers.is((Object)"id-1"));
        Assert.assertThat((Object)((AnypointMqMessage)((List)this.prefetchedDestination.receive().getValue()).get(0)).getId(), (Matcher)Matchers.is((Object)"id-2"));
        Assert.assertThat((Object)this.testDestination.getReceiveCount(), (Matcher)Matchers.is((Object)1));
    }

    private static AnypointMqMessage createTestMessage(String id) {
        return new TestMessage("id-" + id, "body-" + id);
    }

    private ScheduledPrefetcher createPrefetcher(Destination destination, int batchSize, long poolingTime, long lockTimeToLive, final ScheduledExecutorService executorService) {
        return new ScheduledPrefetcher(destination, batchSize, poolingTime, lockTimeToLive){

            protected ScheduledExecutorService createExecutorService() {
                return executorService;
            }
        };
    }
}

